<?php $__env->startSection('title'); ?>
CV Bank
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('frontend_style'); ?>
<!--Toaster Popup message CSS -->

<style>
    @media (min-width: 0) and (max-width: 767.98px) {
        .btn_custom {
            width: 100%;
            margin-bottom: 10px;
        }
    }
    @media (min-width: 768px) and (max-width: 991.98px) {
        .btn_custom {
            width: 100%;
            margin-bottom: 10px;
        }
    }
    p {
        color: #000;
    }
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .bg_dark {
        background: #213143;
    }
    .heading h4 {
        font-weight: 900;
    }
    .personal_info ul li {
        margin-bottom: 10px;
    }
    .personal_info ul li i{
        font-size: 22px;
    }
    .heading_right h1 {
        font-weight: 900;
        color: #fff;
    }
    .heading_right_small {
        background-color: #213143
    }
    .heading_right_small h4{
        font-weight: 900;
        color: #fff;
    }
    .table>:not(caption)>*>* {
        padding: 4px 10px;
    }

    #resume p {
        line-height: 19px;
    }

    /* Styles for the loading popup */
    .loading-popup {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1000;
        }

        .loading-popup-content {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
            color: white;
        }

        .widget-content-area {
            background-image: url('<?php echo e(asset('frontend/assets/img/mbabd.png')); ?>');
            background-repeat: repeat-y;
            /* background-size: auto 100%; */
            background-position: center top;
            /* transform: rotate(90deg); */
            position: relative;
        }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Content Wrapper Start -->
    <div class="content-wrapper" style="">

        <!-- Breadcrumb Start -->
        
        <!-- Breadcrumb End -->

        <!-- Customer Dashboard Start -->
        <div class="container py-5">
            <div class="book-appointment-form h-100 overflow-hidden">
                <div class="row">
                    <div class="col-12">
                        <div class="card p-4">
                            <!-- Loading popup -->
                            <div class="loading-popup" id="loadingPopup">
                                <div class="loading-popup-content">
                                    <h4 style="color: #2490EB">Please wait, your resume is downloading...</h4>
                                    <!-- You can add a spinner or any other loading animation here -->
                                </div>
                            </div>
                            <div class="d-lg-flex justify-content-lg-between text-center text-lg-start align-items-center pb-3">
                                <h2>Job Applicants Details</h2>
                                <div>
                                    <a href="<?php echo e(route('cv.bank')); ?>" class="btn btn-info btn_custom"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>
                                    <button class="btn btn-success btn_custom" id="download"><span><i class="fa-solid fa-download"></i> Download PDF</span></button>
                                </div>
                            </div>
                            <div class="widget-content widget-content-area br-8" id="resume">
                                <div class="row">
                                    <div class="col-4 bg_dark py-4">
                                        <?php if($career->user->profile->profileImage??null): ?>
                                            <div class="avatar-container text-center">
                                                <img alt="avatar"
                                                    src="<?php echo e(asset($career->user->profile->profileImage->profile_image??null)); ?>"
                                                    class="bg-white rounded-circle" style="width:120px; height:120px;">
                                            </div>
                                        <?php else: ?>
                                            <div class="avatar-container text-center">
                                                <img alt="avatar" src="<?php echo e(asset('profile/default_profile.png')); ?>"
                                                class="" style="width:100px">
                                            </div>
                                        <?php endif; ?>
                                        <div class="heading p-2 mt-4 bg-white text-center">
                                            <h4 class="mb-0">Contact Info</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1 bg-white">
                                            <p><i class="fa-solid fa-phone"></i> <span class="ms-3"><?php echo e($career->user->profile->contact_number); ?></span></p>
                                            <p><i class="fa-solid fa-envelope"></i><span class="ms-3"><?php echo e($career->user->email); ?></span></p>
                                            <p><i class="fa-solid fa-house"></i><span class="ms-3"><?php echo e($career->user->profile->address); ?></span></p>
                                            <p><i class="fa-brands fa-linkedin-in"></i><span class="ms-3"><?php echo e($career->user->profile->linkedIn); ?></span></p>
                                        </div>
                                        <div class="heading p-2 mt-1 bg-white text-center">
                                            <h4 class="mb-0">Educational Qualification</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1 bg-white">
                                            <p><?php echo $career->education; ?></p>
                                        </div>
                                        <div class="heading p-2 mt-1 bg-white text-center">
                                            <h4 class="mb-0">Extra Curricular Activities</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1 bg-white">
                                            <p><?php echo $career->extra_cariculam; ?></p>
                                        </div>
                                        <div class="heading p-2 mt-1 bg-white text-center">
                                            <h4 class="mb-0">Language</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1 bg-white">
                                            <p><?php echo $career->language; ?></p>
                                        </div>
                                        <div class="heading p-2 mt-1 bg-white text-center">
                                            <h4 class="mb-0">Skills</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1 bg-white">
                                            <p><?php echo $career->skills; ?></p>
                                        </div>
                                        <div class="heading p-2 mt-1 bg-white text-center">
                                            <h4 class="mb-0">Personal Information</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1 bg-white">
                                            <p></p>
                                        </div>
                                    </div>
                                    <div class="col-8 px-2">
                                        <div class="heading_right p-3 bg_dark text-center">
                                            <h1 class="mb-0"><?php echo e($career->user->name); ?></h1>
                                        </div>
                                        <div class="heading_right_small p-2 mt-1 text-center">
                                            <h4 class="mb-0">Carrer Summery</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1">
                                            <p><?php echo $career->career_summery; ?></p>
                                        </div>
                                        <div class="heading_right_small mt-1 p-2 text-center">
                                            <h4 class="mb-0">Recent Company</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1">
                                            <p><strong>Company Name:</strong> <?php echo e($career->company_name); ?></p>
                                            <p><strong>Designation:</strong> <?php echo e($career->designation); ?></p>
                                        </div>
                                        <div class="heading_right_small mt-1 p-2 text-center">
                                            <h4 class="mb-0">JOb Experience</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1">
                                            <p><?php echo $career->experience; ?></p>
                                        </div>
                                        <div class="heading_right_small mt-1 p-2 text-center">
                                            <h4 class="mb-0">Professional Training & Certifications</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1">
                                            <p><?php echo $career->professional_training; ?></p>
                                        </div>
                                        <div class="heading_right_small mt-1 p-2 text-center">
                                            <h4 class="mb-0">Reference</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1">
                                            <p><?php echo $career->reference; ?></p>
                                        </div>
                                        <div class="heading_right_small mt-1 p-2 text-center">
                                            <h4 class="mb-0">Declaration</h4>
                                        </div>
                                        <div class="personal_info p-2 mt-1">
                                            <p><?php echo $career->declaration; ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Customer Dashboard End -->

    </div>
    <!-- Content wrapper end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('frontend_script'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js" integrity="sha512-GsLlZN/3F2ErC5ifS5QtgpiJtWd43JWSuIgh7mbzZ8zBps+dvLusV+eNQATqgA/HdeKFVgA5v3S/cIrLF7QnIg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    (function() {
        document.getElementById("download").addEventListener("click", function() {
            // Show loading popup
            document.getElementById("loadingPopup").style.display = "block";

            // Simulate download delay (you can remove this timeout in production)
            setTimeout(function() {
                const resumeElement = document.getElementById("resume");
                var options = {
                    margin: [0.3, 0, 0.3, 0], // Top, right, bottom, left margins in inches
                    filename: 'myfile.pdf',
                    image: { type: 'png', quality: 1 },
                    html2canvas: { scale: 2 },
                    jsPDF: { unit: 'in', format: 'letter', orientation: 'portrait' },
                    // pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }
                };

                // Generate PDF
                html2pdf().from(resumeElement).set(options).save();

                // Add CSS to reduce line-height


                // Hide loading popup after download completes (you may need to handle errors and hide the popup accordingly)
                setTimeout(function() {
                    document.getElementById("loadingPopup").style.display = "none";
                }, 1000);
            }, 2000); // Simulated download delay of 2 seconds (remove in production)
        });
    })();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/cvbank/resume.blade.php ENDPATH**/ ?>