<?php $__env->startSection('title'); ?>
    Advisory Committee
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('frontend_style'); ?>
    <!--Toaster Popup message CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        .profile_setting a {
            background-color: transparent !important;
        }

        .profile_setting .active {
            background-color: #2490EB !important;
        }

        .profile_setting .active:hover {
            color: #fff !important;
        }

        .social_link a {
            font-size: 24px;
            color: #2490EB;
        }

        .card-img-top{
            height:120px;
            background: #3162a3;
        }

        .card-no-border .card {
            border-color: #d7dfe3;
            border-radius: 4px;
            margin-bottom: 30px;
            -webkit-box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.05);
            box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.05)
        }

        .card-body {
            -ms-flex: 1 1 auto;
            flex: 1 1 auto;
            padding: 1.25rem
        }

        .pro-img {
            margin-top: -80px;
            margin-bottom: 20px
        }

        .little-profile .pro-img img {
            width: 128px;
            height: 128px;
            -webkit-box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
            border-radius: 100%
        }
        /* Custom Pagiantion Start */
        nav {
            display: flex;
            justify-content: center;
            padding-top: 20px;
        }
        .pagination {
            display: flex;
        }
        .page-item {
            list-style: none;
        }
        .page-link {
            width: 50px;
            height: 50px;
            line-height: 30px;
            text-align: center;
            display: inline-block;
            padding: 10px;
            background-color: #007bff;
            color: #fff;
            border: 1px solid #fff;
            text-decoration: none;
            transition: background-color 0.3s;
        }
        .page-link:hover {
            background-color: #0056b3;
            color: #fff;
        }

        .page-link:focus {
            box-shadow: none;
            outline: none;
        }

        .page-item.active .page-link {
            background-color: #0056b3;
            border: 1px solid #fff;
        }
        /* Custom Pagiantion End */
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($banner->image)); ?>);">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Advisory Committee</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="<?php echo e(route('front.page')); ?>">Home </a></li>
                        <li>Advisory Committee</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Blog  Section Start -->
        <div class="blog-wrap ptb-100">
            <div class="container">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-lg-6 col-md-6">
                            <div class="card blog-card style2" style="min-height: 580px;"> <span class="card-img-top"></span>
                                
                                <div class="card-body little-profile text-center">
                                    <?php if($user->profile->profileImage ?? null): ?>
                                        <div class="pro-img">
                                            <img alt="avatar"
                                                src="<?php echo e(asset($user->profile->profileImage->profile_image ?? null)); ?>">
                                        </div>
                                    <?php else: ?>
                                        <div class="pro-img">
                                            <img alt="avatar" src="<?php echo e(asset('profile/default_profile.png')); ?>">
                                        </div>
                                    <?php endif; ?>
                                    <h3 class="m-b-0"><?php echo e($user->name??null); ?></h3>
                                    <hr>
                                    <?php if($user->career): ?>
                                    <p><strong><?php echo e($user->career->designation??null); ?></strong></p>
                                    <p><strong><?php echo e($user->career->company_name??null); ?></strong></p>
                                    <?php else: ?>
                                        <p class="text-danger"><strong>Hey! Update your CV</strong></p>
                                    <?php endif; ?>
                                    <hr>
                                    <div class="social_link d-flex justify-content-evenly mt-4">
                                        <a target="_blank" href="<?php echo $user->profile->facebook??null; ?>"><i class="fa-brands fa-facebook-f"></i></a>
                                        <a target="_blank" href="<?php echo $user->profile->twitter??null; ?>"><i class="fa-brands fa-twitter"></i></a>
                                        <a target="_blank" href="<?php echo $user->profile->linkedIn??null; ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                                        <a target="_blank" href="<?php echo $user->profile->instagram??null; ?>"><i class="fa-brands fa-instagram"></i></a>
                                    </div>
                                </div>
                                <div class="card-footer px-4 d-flex justify-content-between align-items-center" style="background-color: #3162a3; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px;">
                                        <h5 class="text-white"><?php echo e($user->memberRole->member_role_name); ?></h5>
                                    <!-- Message Envelope Icon/Button -->
                                    <a class="text-white" target="_blank" href="<?php echo e(url('chatify')); ?>" style="font-size: 24px;">
                                        <i class="fa-solid fa-envelope"></i>
                                    </a>
                                </div>

                                <!-- Message Modal -->
                                

                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($users->links()); ?>

                </div>
            </div>
        </div>
        <!-- Blog Section End -->

    </div>
    <!-- Content wrapper end -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('frontend_script'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
    <script>
        <?php if(Session::has('message')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
            }
            toastr.success("<?php echo e(session('message')); ?>");
        <?php endif; ?>

        <?php if(Session::has('error')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>

        <?php if(Session::has('info')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.info("<?php echo e(session('info')); ?>");
        <?php endif; ?>

        <?php if(Session::has('warning')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.warning("<?php echo e(session('warning')); ?>");
        <?php endif; ?>
    </script>
    <script>
        function openMessageModal(userId) {
            // Get the modal element using its ID
            var modal = document.getElementById('messageModal' + userId);

            // Open the modal
            var modalInstance = new bootstrap.Modal(modal);
            modalInstance.show();
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/memberprocedure/advisory.blade.php ENDPATH**/ ?>