<?php
$logo = \App\Models\Logo::latest()->first()
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ID Card</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f3f3f3;
        }
        .id-card {
            width: 300px;
            margin: 20px auto;
            background-color: white;
            border-radius: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-left: 1px solid #999;
            border-right: 1px solid #999;
        }
        .header{
            text-align: center;
            color: white;
            padding: 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .footer {
            text-align: center;
            color: white;
            padding: 6px;
            border-bottom-left-radius: 20px;
            border-bottom-right-radius: 20px;
        }
        .footer p{
            margin: 0;
        }
        /* Color scheme for front card */
        .header.front {
            background-color: #ff7f27; /* Orange */
        }
        .footer.front {
            background-color: #00b5e2; /* Cyan */
        }
        /* Color scheme for back card */
        .header.back {
            background-color: #00b5e2; /* Cyan */
        }
        .footer.back {
            background-color: #ff7f27; /* Orange */
            border-bottom-left-radius: 20px;
            border-bottom-right-radius: 20px;
        }
        .company_info {
            text-align: center;
            margin: 10px 0 0 0;
        }
        .company_info h3{
            margin: 0;
            color: #00b5e2
        }
        .company_info img {
            width: 40px;
        }
        .header h3 {
            margin: 5px 0;
            font-size: 16px;
        }
        .student-info {
            padding: 10px 15px;
            text-align: center;
        }
        .student-info img {
            width: 80px;
            border-radius: 50%;
            border: 2px solid #ff7f27;
            margin-top: 10px;
        }
        .student-info h4 {
            margin: 10px 0 10px 0;
            font-size: 18px;
        }
        .student-info p {
            font-size: 14px;
            margin: 5px 0;
        }
        .student-info .highlight {
            background-color: #66bb6a;
            color: white;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 12px;
            margin-bottom: 10px;
        }
        .student-details {
            font-size: 14px;
            text-align: left;
            padding: 0 15px;
        }
        .student-details p {
            margin: 9px 0;
        }
        .return-info {
            text-align: center;
            padding: 15px;
        }
        .return-info p {
            font-size: 14px;
            margin: 5px 0;
        }
        .sign_img {
            text-align: center;
            margin-top: 69px;
        }
        .signature {
            text-align: center;
            padding: 0 15px 15px 15px;
            font-size: 14px;
            color: rgb(0, 0, 0);
        }
        .signature h3{
            color: black;
            border-top: 1px solid #000;
            margin: 0 40px;
        }
        /* Styles for the loading popup */
    .loading-popup {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: #fff;
        z-index: 1000;
    }

    .loading-popup-content {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        text-align: center;
        color: white;
    }
    </style>
</head>
<body>
    <!-- Front of the ID Card -->
    <div class="loading-popup" id="loadingPopup">
        <div class="loading-popup-content">
            <h4 style="color: #2490EB">Please wait, your resume is downloading...</h4>
            <!-- You can add a spinner or any other loading animation here -->
        </div>
    </div>
    <div class="">
        <div>
            <button class="btn btn-success" id="download"><span><i class="fa-solid fa-download"></i> Download PDF</span></button>
        </div>
    </div>
    <div id="resume">
        <div class="id-card">
            <div class="header front">
            </div>
            <div class="company_info">
                <img src="<?php echo e(asset($logo->logo_image??null)); ?>" alt="Institute Logo">
                <h3>MBABD</h3>
            </div>
            <div class="student-info">
                <div>
                    <span class="highlight">Membership Id Card</span>
                </div>
                <img src="<?php echo e(asset($user->profile->profileImage->profile_image??null)); ?>" alt="Student Photo">
                <h4><?php echo e($user->name); ?></h4>
                <div class="student-details">
                    <p>Member Type:</p>
                    <p>Phone: <?php echo e($user->profile->contact_number); ?></p>
                    <p>Blood Group: <?php echo e($user->profile->blood_group); ?></p>
                    <p>Joined Date:</p>
                    <p>Date of Issue:</p>
                    <p>Date of Validity:</p>
                </div>
            </div>
            <div class="footer front">
                <p>www.mbabd.info</p>
            </div>
        </div>

        <!-- Back of the ID Card -->
        <div class="id-card">
            <div class="header back">
            </div>
            <div class="company_info">
                <img src="<?php echo e(asset($logo->logo_image??null)); ?>" alt="Institute Logo">
                <h3>MBABD</h3>
            </div>
            <div class="return-info">
                <p><strong>Finder Of This Card May Please Return To Following Address</strong></p>
                <p><strong>Mobile: 01977-026322</strong></p>
            </div>
            <div class="sign_img">
                <img src="<?php echo e(asset('sign/sign.png')); ?>" alt="" style="width: 90px">
            </div>
            <div class="signature">
                <h3>Authorised Signature</h3>
                <p><strong>E-mail: pmi.mbabd@gmail.com</strong></p>
                <p><strong>Office Address: House-23, Road-24, Sector-15, Block-C, Uttara, Dhaka</strong></p>
            </div>
            <div class="footer back">
                <p>www.mbabd.info</p>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js" integrity="sha512-GsLlZN/3F2ErC5ifS5QtgpiJtWd43JWSuIgh7mbzZ8zBps+dvLusV+eNQATqgA/HdeKFVgA5v3S/cIrLF7QnIg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    (function() {
        document.getElementById("download").addEventListener("click", function() {
            // Show loading popup
            document.getElementById("loadingPopup").style.display = "block";

            // Simulate download delay (you can remove this timeout in production)
            setTimeout(function() {
                const resumeElement = document.getElementById("resume");
                var options = {
                    margin: [0.3, 0, 0.3, 0], // Top, right, bottom, left margins in inches
                    filename: 'myfile.pdf',
                    image: { type: 'png', quality: 1 },
                    html2canvas: { scale: 2 },
                    jsPDF: { unit: 'in', format: 'letter', orientation: 'portrait' },
                    // pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }
                };

                // Generate PDF
                html2pdf().from(resumeElement).set(options).save();

                // Add CSS to reduce line-height


                // Hide loading popup after download completes (you may need to handle errors and hide the popup accordingly)
                setTimeout(function() {
                    document.getElementById("loadingPopup").style.display = "none";
                }, 1000);
            }, 2000); // Simulated download delay of 2 seconds (remove in production)
        });
    })();
</script>
</body>
</html>
<?php /**PATH C:\laragon\www\mbabd\resources\views/admin/merchandiser_role/idcard.blade.php ENDPATH**/ ?>