<?php $__env->startSection('title'); ?>
    <?php echo e(Auth::user()->name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('frontend_style'); ?>
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<link rel="stylesheet" href="<?php echo e(asset('ijaboCropTool/ijaboCropTool.min.css')); ?>">
<style>
    .loader {
        display: none;
        position: fixed;
        z-index: 999;
        height: 2em;
        width: 2em;
        overflow: show;
        margin: auto;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
    }

    .loader:before {
        content: '';
        display: block;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.3);
    }

    .loader:after {
        content: '';
        display: block;
        position: absolute;
        top: 50%;
        left: 50%;
        width: 1em;
        height: 1em;
        margin-top: -0.5em;
        margin-left: -0.5em;
        border-radius: 50%;
        border: 0.2em solid transparent;
        border-top-color: #3498db;
        animation: spinner 0.6s linear infinite;
    }

    @keyframes  spinner {
        to { transform: rotate(360deg); }
    }
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .custom-control-input:checked ~ .custom-control-label::before {
            background-color: #007bff;
            border-color: #007bff;
        }

        .custom-control-label::before {
            border: 1px solid #007bff;
        }

        .custom-control-input:checked ~ .custom-control-label::after {
            background-color: #fff;
        }

        .custom-control-label::before,
        .custom-control-input:checked ~ .custom-control-label::after {
            width: 1.5rem;
            height: 1.5rem;
        }

        .custom-control-input:checked ~ .custom-control-label::after {
            width: 0.75rem;
            height: 0.75rem;
        }

        .custom-control-label::before,
        .custom-control-input:checked ~ .custom-control-label::after {
            border-radius: 0;
        }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($banner->image)); ?>);">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>User Information</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="<?php echo e(route('front.page')); ?>">Home </a></li>
                        <li>User Information</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Loader Element -->
        <div class="loader"></div>

        <!-- Customer Dashboard Start -->
        <div class="container py-5">
            <div class="book-appointment-form">
                <div class="row">
                    <div class="col-12">
                        <div class="d-none d-lg-block">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h2 class="font-weight-bold py-3 mb-4">Account settings</h2>
                                </div>
                                <div>
                                    <h4 class="text_custom">Welcome Back, <?php echo e(Auth::user()->name); ?>!</h4>
                                    <h6>Department: <?php echo e(Auth::user()->companyDepartment->company_department_name); ?></h6>
                                </div>
                            </div>
                        </div>
                        <div class="d-lg-none">
                            <h4 class="font-weight-bold">Account settings</h4>
                            <div>
                                <h4 class="text_custom">Welcome Back, <?php echo e(Auth::user()->name); ?>!</h4>
                                <h6>Department: <?php echo e(Auth::user()->companyDepartment->company_department_name); ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 pt-0">
                        <div class="list-group profile_setting">
                            <a class="list-group-item active py-3" data-toggle="list"
                                href="#account-general">General</a>
                            <a class="list-group-item py-3" data-toggle="list"
                                href="#account-info">Personal Information</a>
                            <?php if($profile): ?>
                            <a class="list-group-item py-3" data-toggle="list"
                            href="#account-profile">Profile</a>
                            <?php endif; ?>
                            <a class="list-group-item py-3" data-toggle="list"
                                href="#career-info">Update Your CV <span class="text-danger">*</span></a>
                            <a class="list-group-item py-3" data-toggle="list"
                                href="#account-change-password">Change password</a>
                            <a class="list-group-item py-3" href="<?php echo e(route('job.history')); ?>">Your Job History</a>
                            <?php if($career): ?>
                                <a class="list-group-item py-3" href="<?php echo e(route('view.resume', ['user_id' => $career->user_id??null])); ?>">View CV</a>
                            <?php endif; ?>
                            <a href="" class="list-group-item py-3" onclick="event.preventDefault(); document.getElementById('logoutForm').submit()"> Logout</a>
                            <form action="<?php echo e(route('logout')); ?>" id="logoutForm" method="POST">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="tab-content">

                            <!-- General Setting Start -->
                            <div class="tab-pane fade active show" id="account-general">
                                <div class="card-body media align-items-center">
                                    <h4>General Setting</h4>
                                    <?php if($profile): ?>
                                        <?php if($profileImage && $profileImage->profile_image): ?>
                                            <img src="<?php echo e(asset($profileImage->profile_image)); ?>" class="profile_image" alt="Profile Image" style="width: 200px; height: 200px; border: 5px solid #2490EB; border-radius: 50%;">
                                        <?php endif; ?>
                                    <?php else: ?>
                                    <img src="<?php echo e(asset('profile/default_profile.png')); ?>" class="profile_image" style="width: 200px; height: 200px; border-radius: 50%;" alt="Default Profile Image">
                                    <?php endif; ?>

                                    <form action="<?php echo e(route('customer.update')); ?>" method="POST" enctype="multipart/form-data" class="mt-4">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($user->id); ?>">
                                        <div class="form-group mb-3">
                                            <label for="" class="form-label">Username</label>
                                            <input type="text" name="name" class="form-control rounded-0" value="<?php echo e($user->name); ?>">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="" class="form-label">Email</label>
                                            <input type="email" name="email" class="form-control rounded-0" value="<?php echo e($user->email); ?>">
                                        </div>
                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- Profile Setting Start -->
                            <?php if($profile): ?>
                            <div class="tab-pane fade" id="account-profile">
                                <div class="card-body media align-items-center">
                                    <h4>Profile Setting</h4>
                                    <?php if($profileImage && $profileImage->profile_image): ?>
                                        <img src="<?php echo e(asset($profileImage->profile_image)); ?>" class="profile_image" alt="Profile Image" style="width: 200px; height: 200px; border: 5px solid #2490EB;  border-radius: 50%;">
                                    <?php else: ?>
                                    <img src="<?php echo e(asset('profile/default_profile.png')); ?>" class="profile_image" style="width: 200px; height: 200px; border-radius: 50%;">
                                    <?php endif; ?>
                                    <div class="form-group mt-4">
                                        <label for="">Change Picture</label>
                                        <input type="file" name="profile_image" class="form-control rounded-0" id="profile_image">
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <!-- Password Setting Start -->
                            <div class="tab-pane fade" id="account-change-password">
                                <div class="card-body pb-2">
                                    <h4>Password Setting</h4>
                                    <form action="<?php echo e(route('mypostupdate.password')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group mb-3">
                                            <label for="old_password" class="form-label">Current password</label>
                                            <input type="password" name="old_password" class="form-control rounded-0 <?php $__errorArgs = ['old_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <?php $__errorArgs = ['old_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="password" class="form-label">New password</label>
                                            <input type="password" name="password" class="form-control rounded-0 <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="password_confirmation" class="form-label">Repeat new password</label>
                                            <input type="password" name="password_confirmation" class="form-control rounded-0">
                                        </div>
                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- Personal Information Setting Start -->
                            <div class="tab-pane fade" id="account-info">
                                <div class="card-body pb-2">
                                    <h4>Personal Information Setting</h4>
                                    <form action="<?php echo e(route('customer.info.store')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group mb-3">
                                            <label for="nid_num" class="form-label">Nid Number</label>
                                            <input type="number" name="nid_num" class="form-control rounded-0" value="<?php echo e($profile->nid_num??null); ?>">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="contact_number" class="form-label">Contact Number</label>
                                            <input type="tel" name="contact_number" class="form-control rounded-0 <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($profile->contact_number??null); ?>">
                                            <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="address" class="form-label">Address</label>
                                            <textarea class="form-control rounded-0 <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="address" col="10" rows="5"><?php echo e($profile->address??null); ?></textarea>
                                            <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="blood_group" class="form-label">Blood Group</label>
                                            <input type="text" name="blood_group" class="form-control rounded-0" value="<?php echo e($profile->blood_group??null); ?>">
                                        </div>
                                        <?php if($profile): ?>
                                        <div class="form-group mb-3">
                                            <label class="form-label">Blood Donner?(Yes/No)</label>
                                            <select class="form-control rounded-0" name="blood_donner">
                                                <option value="1" <?php if($profile->blood_donner == 1): ?> selected <?php endif; ?>>Yes</option>
                                                <option value="0" <?php if($profile->blood_donner == 0): ?> selected <?php endif; ?>>No</option>
                                            </select>
                                        </div>
                                        <?php else: ?>
                                        <div class="form-group mb-3">
                                            <label class="form-label">Blood Donner?(Yes/No)</label>
                                            <select class="form-control rounded-0" name="blood_donner">
                                                <option value="1">Yes</option>
                                                <option value="0">No</option>
                                            </select>
                                        </div>
                                        <?php endif; ?>

                                        <div class="form-group mb-3">
                                            <label for="date_of_birth" class="form-label">Date of Birth</label>
                                            <input type="date" name="date_of_birth" class="form-control rounded-0 <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($profile->date_of_birth??null); ?>">
                                            <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <label for="gender" class="form-label">Select Gender</label>
                                        <div class="form-group d-flex mb-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="gender" id="male" value="male"
                                                <?php if($profile): ?>
                                                <?php echo e($profile->gender == 'male' ? 'checked' : ''); ?>

                                                <?php endif; ?>>
                                                <label class="form-check-label" for="male">
                                                  Male
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="gender" id="female" value="female"
                                                <?php if($profile): ?>
                                                <?php echo e($profile->gender == 'female' ? 'checked' : ''); ?>

                                                <?php endif; ?>>
                                                <label class="form-check-label" for="female">
                                                  Female
                                                </label>
                                            </div>
                                        </div>
                                        <label for="marital_status" class="form-label">Marital Status</label>
                                        <div class="form-group d-flex mb-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="marital_status" id="married" value="married"
                                                <?php if($profile): ?>
                                                <?php echo e($profile->marital_status == 'married' ? 'checked' : ''); ?>

                                                <?php endif; ?>>
                                                <label class="form-check-label" for="married">
                                                    Married
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="marital_status" id="unmarried" value="unmarried"
                                                <?php if($profile): ?>
                                                <?php echo e($profile->marital_status == 'unmarried' ? 'checked' : ''); ?>

                                                <?php endif; ?>>
                                                <label class="form-check-label" for="unmarried">
                                                    Unmarried
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="facebook" class="form-label">Facebook (url)</label>
                                            <input type="text" name="facebook" class="form-control rounded-0" value="<?php echo e($profile->facebook??null); ?>">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="twitter" class="form-label">Twitter (url)</label>
                                            <input type="text" name="twitter" class="form-control rounded-0" value="<?php echo e($profile->twitter??null); ?>">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="linkedIn" class="form-label">LinkedIn (url)</label>
                                            <input type="text" name="linkedIn" class="form-control rounded-0" value="<?php echo e($profile->linkedIn??null); ?>">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="instagram" class="form-label">Instagram (url)</label>
                                            <input type="text" name="instagram" class="form-control rounded-0" value="<?php echo e($profile->linkedIn??null); ?>">
                                        </div>
                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- Update Your CV Start -->
                            <div class="tab-pane fade" id="career-info">
                                <div class="card-body pb-2">
                                    <?php if($profile && $profileImage): ?>
                                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                                            <strong>Congratulation! !! Now you can update your CV</strong>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                            <strong>Before update your CV, You must update your personal information and profile very carefully.</strong>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($profile && $profileImage): ?>
                                    <form action="<?php echo e(isset($career) ? route('career.storeOrUpdate', ['id' => $career->id]) : route('career.storeOrUpdate')); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <?php if(isset($career)): ?>
                                            <?php echo method_field('PUT'); ?>
                                        <?php endif; ?>
                                        <div class="form-group mb-3">
                                            <label for="designation" class="form-label">Designation <span class="text-danger">*</span></label>
                                            <input type="text" name="designation" class="form-control rounded-0 <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" <?php if($career): ?>
                                                value="<?php echo e($career->designation??null); ?>"
                                                <?php else: ?>
                                                value="<?php echo e(old('designation')); ?>"
                                            <?php endif; ?>>
                                            <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="university" class="form-label">University <span class="text-danger">*</span></label>
                                            <input type="text" name="university" class="form-control rounded-0 <?php $__errorArgs = ['university'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" <?php if($career): ?>
                                            value="<?php echo e($career->university??null); ?>"
                                            <?php else: ?>
                                            value="<?php echo e(old('university')); ?>"
                                            <?php endif; ?>>
                                            <?php $__errorArgs = ['university'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="company_name" class="form-label">Company Name (Recent) <span class="text-danger">*</span></label>
                                            <input type="text" name="company_name" class="form-control rounded-0 <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" <?php if($career): ?>
                                            value="<?php echo e($career->company_name??null); ?>"
                                            <?php else: ?>
                                            value="<?php echo e(old('company_name')); ?>"
                                            <?php endif; ?>>>
                                            <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="career_summery" class="form-label">Career Summery <span class="text-danger">*</span></label>
                                            <textarea id="career" class="form-control rounded-0 <?php $__errorArgs = ['career_summery'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="career_summery" col="10" rows="5"><?php if($career): ?>
                                            <?php echo $career->career_summery??null; ?>

                                            <?php else: ?>
                                            <?php echo old('career_summery'); ?>

                                            <?php endif; ?></textarea>
                                            <?php $__errorArgs = ['career_summery'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="skills" class="form-label">Skills <span class="text-danger">*</span></label>
                                            <textarea id="skill" class="form-control rounded-0 <?php $__errorArgs = ['skills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="skills" col="10" rows="5">
                                            <?php if($career): ?>
                                            <?php echo $career->skills??null; ?>

                                            <?php else: ?>
                                            <?php echo old('skills'); ?>

                                            <?php endif; ?>
                                            </textarea>
                                            <?php $__errorArgs = ['skills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="experience" class="form-label">Job Experience <span class="text-danger">*</span></label>
                                            <textarea id="experience" class="form-control rounded-0 <?php $__errorArgs = ['experience'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="experience" col="10" rows="5">
                                            <?php if($career): ?>
                                            <?php echo $career->experience??null; ?>

                                            <?php else: ?>
                                            <?php echo old('experience'); ?>

                                            <?php endif; ?>
                                            </textarea>
                                            <?php $__errorArgs = ['experience'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="education" class="form-label">Education <span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 <?php $__errorArgs = ['education'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="education" name="education" col="10" rows="5">
                                            <?php if($career): ?>
                                            <?php echo $career->education??null; ?>

                                            <?php else: ?>
                                            <?php echo old('education'); ?>

                                            <?php endif; ?>
                                            </textarea>
                                            <?php $__errorArgs = ['education'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="extra_cariculam" class="form-label">Extra Curriculum <span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 <?php $__errorArgs = ['extra_cariculam'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="extra_cariculam" name="extra_cariculam" col="10" rows="5">
                                            <?php if($career): ?>
                                            <?php echo $career->extra_cariculam??null; ?>

                                            <?php else: ?>
                                            <?php echo old('extra_cariculam'); ?>

                                            <?php endif; ?>
                                            </textarea>
                                            <?php $__errorArgs = ['extra_cariculam'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="language" class="form-label">Language <span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 <?php $__errorArgs = ['language'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="language" name="language" col="10" rows="5">
                                            <?php if($career): ?>
                                            <?php echo $career->language??null; ?>

                                            <?php else: ?>
                                            <?php echo old('language'); ?>

                                            <?php endif; ?>
                                            </textarea>
                                            <?php $__errorArgs = ['language'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="professional_training" class="form-label">Professional Training <span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 <?php $__errorArgs = ['professional_training'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="professional_training" name="professional_training" col="10" rows="5">
                                            <?php if($career): ?>
                                            <?php echo $career->professional_training??null; ?>

                                            <?php else: ?>
                                            <?php echo old('professional_training'); ?>

                                            <?php endif; ?>
                                            </textarea>
                                            <?php $__errorArgs = ['professional_training'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="reference" class="form-label">Reference(name, company, position, number, email)<span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 <?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="reference" name="reference" col="10" rows="5">
                                            <?php if($career): ?>
                                            <?php echo $career->reference??null; ?>

                                            <?php else: ?>
                                            <?php echo old('reference'); ?>

                                            <?php endif; ?>
                                            </textarea>
                                            <?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="declaration" class="form-label">Declaration<span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 <?php $__errorArgs = ['declaration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="declaration" name="declaration" col="10" rows="5">
                                            <?php if($career): ?>
                                            <?php echo $career->declaration??null; ?>

                                            <?php else: ?>
                                            <?php echo old('declaration'); ?>

                                            <?php endif; ?>
                                            </textarea>
                                            <?php $__errorArgs = ['declaration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="office_idcard" class="form-label mb-2">Office ID Card(Picture of frontside) <span class="text-danger">*</span></label>
                                            <input type="file" class="form-control <?php $__errorArgs = ['office_idcard'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            is-invalid
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="5" name="office_idcard" id="office_idcard">
                                            <?php $__errorArgs = ['office_idcard'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <div>
                                                <img src="<?php echo e(asset('idcard')); ?>/<?php echo e($career->office_idcard??null); ?>" class="img-fluid w-25" alt="" >
                                            </div>
                                        </div>

                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </form>
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Customer Dashboard End -->

    </div>
    <!-- Content wrapper end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('frontend_script'); ?>
<!-- jQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/35.1.0/classic/ckeditor.js"></script>
<script src="<?php echo e(asset('ijaboCropTool/ijaboCropTool.min.js')); ?>"></script>
<!-- Cropper.js JS -->
<script>
    <?php if(Session::has('message')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("<?php echo e(session('message')); ?>");
    <?php endif; ?>

    <?php if(Session::has('error')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>

    <?php if(Session::has('info')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("<?php echo e(session('info')); ?>");
    <?php endif; ?>

    <?php if(Session::has('warning')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("<?php echo e(session('warning')); ?>");
    <?php endif; ?>
</script>
<script>
    ClassicEditor
    .create( document.querySelector( '#skill' ) )
    .catch( error => {
        console.error( error );
    } );

    ClassicEditor
    .create( document.querySelector( '#experience' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#career' ) )
    .catch( error => {
        console.error( error );
    } );

    ClassicEditor
    .create( document.querySelector( '#education' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#extra_cariculam' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#language' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#professional_training' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#reference' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#declaration' ) )
    .catch( error => {
        console.error( error );
    } );
</script>

<script>
    $(document).ready(function() {
        $('#profile_image').ijaboCropTool({
            preview: '.profile_image',
            processUrl: '<?php echo e(route("image.crop")); ?>',
            withCSRF: ['_token', '<?php echo e(csrf_token()); ?>'],
            buttonsText: ['CROP & SAVE', 'QUIT NOW'],
            buttonsColor: ['#30bf7d', '#ee5155', -15],
            onSuccess: function(message, element, status) {
                $('.loader').hide();
                toastr.success('Image updated successfully!');
            },
            onError: function(message, element, status) {
                $('.loader').hide();
                toastr.error('Failed to update image. Please try again.');
            },
            onBefore: function() {
                $('.loader').show();
            },
        });

        // Show the loader when the CROP & SAVE button is clicked
        $(document).on('click', '.ijaboCropTool_btn.c_save', function() {
            $('.loader').show();
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\mbabd\resources\views/frontend/customer/customer_dashboard.blade.php ENDPATH**/ ?>