<?php $__env->startSection('title'); ?>
CV Bank
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('frontend_style'); ?>
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<link rel="stylesheet" type="text/css"
      href="<?php echo e(asset('/')); ?>admin/assets/node_modules/datatables.net-bs4/css/dataTables.bootstrap4.css">
<link rel="stylesheet" type="text/css"
      href="<?php echo e(asset('/')); ?>admin/assets/node_modules/datatables.net-bs4/css/responsive.dataTables.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .text_custom {
        color: #2490EB !important;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($banner->image??null)); ?>);">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>CV Bank Information</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="<?php echo e(route('front.page')); ?>">Home </a></li>
                    <li>CV Bank Information</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Job List Start -->
    <div class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center mb-5">
                    <h1>Find Your Apparel Merchandising Professional Guys</h1>
                </div>
                <div class="col-lg-12 login-form-wrap">
                    <div class="table-responsive">
                        <table id="dataTable" class="table display table-striped border no-wrap">
                            <thead>
                            <tr>
                                <th>List</th>
                                <th>Last Updated</th>
                                <th>Profile</th>
                                <th>Name</th>
                                <th>Designation</th>
                                <th>University</th>
                                <th>Experience</th>
                                
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($career->user->role_id == 4 && $career->user->is_merchandiser == 1): ?>
                            <tr>
                                <td><?php echo e(++$key); ?></td>
                                <td><?php echo e($career->updated_at->format('d-M-Y')); ?></td>
                                <td>
                                    <?php if($career->user->profile->profileImage??null): ?>
                                    <div class="avatar-container">
                                        <img alt="avatar"
                                            src="<?php echo e(asset($career->user->profile->profileImage->profile_image??null)); ?>"
                                            class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                    <?php else: ?>
                                    <div class="avatar-container">
                                        <img alt="avatar" src="<?php echo e(asset('profile/default_profile.png')); ?>"
                                        class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($career->user->name); ?></td>
                                <td><?php echo e($career->designation); ?></td>
                                <td><?php echo e($career->university); ?></td>
                                <td><?php echo Str::limit($career->experience, $limit = 25, $end = '...'); ?></td>
                                
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div>
                                            <a href="<?php echo e(route('cv_bank.resume', ['id' => $career->id])); ?>"
                                                class="action-btn bs-tooltip me-2" data-toggle="tooltip"
                                                data-placement="top" title="" data-bs-original-title="View">
                                                <i class="fa-solid fa-eye text-success"></i>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
    
                        </table>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
    <!-- Job List End -->

</div>
<!-- Content wrapper end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('frontend_script'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<!-- This is data table -->
<script src="<?php echo e(asset('/')); ?>admin/assets/node_modules/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="<?php echo e(asset('/')); ?>admin/assets/node_modules/datatables.net-bs4/js/dataTables.responsive.min.js"></script>
<script>
    $(function () {
        // Initialize DataTable for #myTable (if exists)
        $('#myTable').DataTable();

        // Initialize DataTable for #example with options
        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function (settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function (group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });

        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function () {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });

        // Initialize DataTable for #dataTable with responsive option
        $('#dataTable').DataTable({
            responsive: true
        });

        // Initialize DataTable for #example23 with buttons
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });

        // Add button styling
        $('.buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel').addClass('btn btn-primary me-1');
    });
</script>

<script>
    <?php if(Session::has('message')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("<?php echo e(session('message')); ?>");
    <?php endif; ?>

    <?php if(Session::has('error')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>

    <?php if(Session::has('info')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("<?php echo e(session('info')); ?>");
    <?php endif; ?>

    <?php if(Session::has('warning')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("<?php echo e(session('warning')); ?>");
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/cvbank/index.blade.php ENDPATH**/ ?>