<?php $__env->startSection('title'); ?>
    Recruiter Company
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php $logo = \App\Models\Logo::latest()->first() ?>
    <link rel="icon" type="image/png" href="<?php echo e(asset($logo->logo_image)); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($banner->image??null)); ?>);">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Recruiter Company</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="<?php echo e(route('front.page')); ?>">Home </a></li>
                    <li>Recruiter Company</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Service Details section Start -->
    <section class="service-details-wrap ptb-100">
        <div class="container">
            <div class="row gx-5">
                <div class="col-md-12 col-lg-6">
                    <h2><?php echo e($recruiter->title??null); ?></h2>
                    <p><?php echo $recruiter->description??null; ?></p>
                    <div>
                        <?php if(auth()->guard('recruiter')->check()): ?>
                            <a href="<?php echo e(route('recruiter.dashboard')); ?>" class="btn style1 rounded-0">My Account</a>
                            <a href="<?php echo e(route('applyjob.index')); ?>" class="btn style1 rounded-0">My Job Circular History</a>
                        <?php endif; ?>

                        <?php if(auth()->guard('recruiter')->guest()): ?>
                            <a href="<?php echo e(route('login.page')); ?>" class="btn style1 rounded-0">Sign In</a>
                            <a href="<?php echo e(route('register.page')); ?>" class="btn style1 rounded-0">Sign Up</a>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="col-md-12 col-lg-6 mt-4 mt-lg-0">
                    <img src="<?php echo e(asset($recruiter->recruiter_photo??null)); ?>" class="img-fluid" alt="">
                </div>
            </div>
        </div>
    </section>
    <!-- Service Details section End -->


</div>
<!-- Content wrapper end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/recruiter/recruiter.blade.php ENDPATH**/ ?>