
<?php $__env->startSection('title'); ?>
    Orientation Member
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('frontend_style'); ?>
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .social_link a {
        font-size: 24px;
        color: #2490EB;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($banner->image)); ?>);">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Orientation Member</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="<?php echo e(route('front.page')); ?>">Home </a></li>
                        <li>Orientation Member</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Blog  Section Start -->
        <div class="blog-wrap ptb-100">
            <div class="container">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="blog-card style2 p-4">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h3><a href="blog-details-right-sidebar.html"><?php echo e($user->name); ?> </a></h3>
                                <?php if($user->adminProfileImage): ?>
                                    <div class="avatar-container">
                                        <img alt="avatar"
                                            src="<?php echo e(asset($user->adminProfileImage->admin_profile_image)); ?>"
                                            class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                <?php elseif($user->profile->profileImage??null): ?>
                                    <div class="avatar-container">
                                        <img alt="avatar"
                                            src="<?php echo e(asset($user->profile->profileImage->profile_image??null)); ?>"
                                            class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                <?php else: ?>
                                    <div class="avatar-container">
                                        <img alt="avatar" src="<?php echo e(asset('profile/default_profile.png')); ?>"
                                        class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                <?php endif; ?>
                                
                            </div>
                            <div>
                                <table class="table table-striped table-bordered table-hover">
                                    <tbody>
                                        <tr>
                                            <th>Name</th>
                                            <td><?php echo e($user->name); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td><?php echo e($user->email); ?></td>
                                        </tr>
                                        <tr>
                                            <th>University</th>
                                            <td><?php echo e($user->career->university ?? 'N/A'); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Address</th>
                                            <td><?php echo e($user->profile->address ?? 'N/A'); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Blood Group</th>
                                            <td><?php echo e($user->profile->blood_group ?? 'N/A'); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="social_link d-flex justify-content-evenly">
                                <a href="<?php echo $user->profile->facebook??null; ?>"><i class="fa-brands fa-facebook-f"></i></a>
                                <a href="<?php echo $user->profile->twitter??null; ?>"><i class="fa-brands fa-twitter"></i></a>
                                <a href="<?php echo $user->profile->linkedIn??null; ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                                <a href="<?php echo $user->profile->instagram??null; ?>"><i class="fa-brands fa-instagram"></i></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($users->links()); ?>

                </div>
            </div>
        </div>
        <!-- Blog Section End -->

    </div>
    <!-- Content wrapper end -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('frontend_script'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    <?php if(Session::has('message')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("<?php echo e(session('message')); ?>");
    <?php endif; ?>

    <?php if(Session::has('error')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>

    <?php if(Session::has('info')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("<?php echo e(session('info')); ?>");
    <?php endif; ?>

    <?php if(Session::has('warning')): ?>
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("<?php echo e(session('warning')); ?>");
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/orientation_member/orientation.blade.php ENDPATH**/ ?>