<?php $__env->startSection('title', 'Member Forum'); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('frontend_style'); ?>
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .social_link a {
        font-size: 24px;
        color: #2490EB;
    }
    .card-img-top{
        height:300px;
    }
    .card-no-border .card {
        border-color: #d7dfe3;
        border-radius: 4px;
        margin-bottom: 30px;
        -webkit-box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.05);
        box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.05)
    }
    .card-body {
        -ms-flex: 1 1 auto;
        flex: 1 1 auto;
        padding: 1.25rem
    }
    .pro-img {
        margin-top: -80px;
        margin-bottom: 20px
    }
    .little-profile .pro-img img {
        width: 128px;
        height: 128px;
        -webkit-box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
        border-radius: 100%
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Member Forum</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="<?php echo e(route('front.page')); ?>">Home</a></li>
                    <li>Member Forum</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Recipient Details and Message Form Start -->
    <div class="recipient-details-wrap ptb-100">
        <div class="container">
            <div class="row py-5">
                <div class="col-md-4">
                    <div class="card blog-card style2">
                        <img class="card-img-top" src="<?php echo e(asset($banner->image)); ?>" alt="Card image cap">
                        <div class="card-body little-profile text-center">
                            <div class="pro-img">
                                <img alt="avatar" src="<?php echo e(asset($recipient->profile->profileImage->profile_image ?? 'profile/default_profile.png')); ?>">
                            </div>
                            <h3 class="m-b-0"><?php echo e($recipient->name); ?></h3>
                            <?php if($recipient->career): ?>
                            <p><strong>Designation:</strong> <?php echo e($recipient->career->designation); ?></p>
                            <p><strong>Company Name:</strong> <?php echo e($recipient->career->company_name); ?></p>
                            <?php else: ?>
                            <p class="text-danger"><strong>Hey! Update your CV</strong></p>
                            <?php endif; ?>
                            <hr>
                            <div class="social_link d-flex justify-content-evenly mt-4">
                                <a href="<?php echo e($recipient->profile->facebook ?? '#'); ?>"><i class="fa-brands fa-facebook-f"></i></a>
                                <a href="<?php echo e($recipient->profile->twitter ?? '#'); ?>"><i class="fa-brands fa-twitter"></i></a>
                                <a href="<?php echo e($recipient->profile->linkedin ?? '#'); ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                                <a href="<?php echo e($recipient->profile->instagram ?? '#'); ?>"><i class="fa-brands fa-instagram"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-4 blog-card style2">
                        <div class="card-body">
                            <h4>Send a Message</h4>
                            <form action="<?php echo e(route('message.store')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="recipient_id" value="<?php echo e($recipient->id); ?>">
                                <div class="form-group">
                                    <label for="message_description">Message</label>
                                    <textarea name="message_description" id="message_description" class="form-control" rows="4" required></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary mt-3">Send</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">

                </div>
            </div>
        </div>
    </div>
    <!-- Recipient Details and Message Form End -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('frontend_script'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    <?php if(Session::has('message')): ?>
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
        }
        toastr.success("<?php echo e(session('message')); ?>");
    <?php endif; ?>

    <?php if(Session::has('error')): ?>
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>

    <?php if(Session::has('info')): ?>
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.info("<?php echo e(session('info')); ?>");
    <?php endif; ?>

    <?php if(Session::has('warning')): ?>
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.warning("<?php echo e(session('warning')); ?>");
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/memberprocedure/send_message.blade.php ENDPATH**/ ?>