<?php $__env->startSection('title'); ?>
    Home
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('frontend_style'); ?>
<style>
    .carousel-item {
        position: relative;
    }

    .overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5); /* Adjust the opacity as needed */
        z-index: 1;
    }

    .carousel-caption {
        z-index: 2;
        position: absolute;
        top: 40%;
    }

    .carousel_big_img img,
    .carousel_four_img img {
        /* z-index: 0; */
    }
    .carousel_big_img {
        position: relative;
    }
    .carousel_four_img{
        position: absolute;
        top: 15%;
        left: 65%;
        transform: rotate(45deg);
        z-index: 1;
    }
    @media (min-width: 0) and (max-width: 767.98px) {
        .carousel_four_img{
            display: none;
        }

        .carousel-caption {
            top: 10%;
        }
    }
    @media (min-width: 768px) and (max-width: 991.98px) {
        .carousel_four_img{
            top: 25%;
        }
        .carousel_four_img img{
            width: 40%;
        }
    }
    @media (min-width: 992px) and (max-width: 1199.98px) {
        .carousel_four_img{
            top: 30%;
        }
        .carousel_four_img img{
            width: 40%;
        }
    }
    @media (min-width: 1200px) and (max-width: 1439.98px) {
        .carousel_four_img{
            top: 25%;
        }
        .carousel_four_img img{
            width: 40%;
        }
    }

    .blink {
        animation: blinker 1.5s linear infinite;
        color: red;
        background: #eeeeee;
        padding: 10px;
    }
    .blink h5 {
        color: #2490EB;
    }

    @keyframes  blinker {
        50% {
            opacity: 0.5;
        }
    }
    .box {
        display: flex;
    }
    /* Button styling */
    .video-btn {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  padding: 15px;
  font-size: 16px;
  font-weight: bold;
  text-align: center;
  color: #fff;
  background-color: #007BFF;
  border: none;
  border-radius: 50%;
  cursor: pointer;
  transition: background-color 0.3s ease;
  position: relative;
  width: 60px;
  height: 60px;
  overflow: hidden;
}

.video-btn::before {
  content: '';
  position: absolute;
  top: 50%;
  left: 50%;
  width: 0;
  height: 0;
  border-left: 10px solid #fff;
  border-top: 6px solid transparent;
  border-bottom: 6px solid transparent;
  transform: translate(-50%, -50%);
}

.video-btn:hover {
  background-color: #0056b3;
}

.video-btn::after {
  content: '';
  position: absolute;
  width: 200%;
  height: 200%;
  top: 50%;
  left: 50%;
  background: rgba(255, 255, 255, 0.5);
  transform: translate(-50%, -50%) scale(0);
  border-radius: 50%;
  animation: wave 1.5s infinite ease-out;
}

@keyframes  wave {
  0% {
    transform: translate(-50%, -50%) scale(0);
    opacity: 1;
  }
  100% {
    transform: translate(-50%, -50%) scale(1);
    opacity: 0;
  }
}

/* Modal (background) */
.modal {
  display: none;
  position: fixed;
  z-index: 99999;
  left: 0;
  top: 10%;
  width: 100%;
  height: 100%;
  overflow: auto;
  background-color: rgba(0,0,0,0.6);
  justify-content: center;
  align-items: center;
  animation: fadeIn 0.3s;
  display: flex;
}

/* Modal Content/Box */
.modal-content {
  position: relative;
  background-color: #fff;
  margin: auto;
  padding: 0;
  border-radius: 10px;
  width: 80%;
  max-width: 700px;
  box-shadow: 0 4px 8px rgba(0,0,0,0.2);
  animation: slideIn 0.3s;
  overflow: hidden;
}

/* Responsive adjustments */
@media (max-width: 767.98px) {
  .modal-content {
    width: 95%;
    max-width: none;
    height: 80%;
  }

  .modal-content iframe {
    width: 100%;
    height: 100%;
  }
}

/* Add Animations */
@keyframes  fadeIn {
  from {opacity: 0;}
  to {opacity: 1;}
}

@keyframes  slideIn {
  from {transform: translateY(-50px);}
  to {transform: translateY(0);}
}

/* The Close Button */
.close {
  position: absolute;
  top: 10px;
  right: 20px;
  color: #2490EB;
  font-size: 30px;
  font-weight: bold;
  cursor: pointer;
}

.close:hover,
.close:focus {
  color: #2490EB;
  text-decoration: none;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Hero Section Start -->
    <section class="hero-wrap style2" style="padding: 0px;">
        <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner mt-5">
                <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="carousel-item <?php echo e($key == 0 ? 'active' : ''); ?>">
                    <div class="img-gradient carousel_big_img">
                        <div class="overlay"></div>
                        <img src="<?php echo e(asset($banner->image1)); ?>" class="d-block w-100 banner-img" alt="Banner Image">
                        <div class="carousel-caption text-start banner_text">
                            <h1 class="text-white"><?php echo e($banner->title); ?></h1>
                            <p class="text-white"><?php echo e($banner->short_details); ?></p>
                            <!-- Trigger button or element -->
                            <div class="d-flex align-items-center">
                                <span>Watch Video</span><button id="openVideoBtn" class="video-btn ms-3" data-video-id="<?php echo e($banner->video_id); ?>"></button>
                            </div>

                            <!-- The Modal -->
                        </div>
                        <div class="carousel_four_img">
                            <div>
                                <img data-aos="fade-down-right" data-aos-duration="1200" data-aos-delay="200" src="<?php echo e(asset($banner->image2)); ?>" class="p-2 img-fluid" alt="Additional Image 1">
                                <img data-aos="fade-down-left" data-aos-duration="1200" data-aos-delay="200" src="<?php echo e(asset($banner->image3)); ?>" class="p-2 img-fluid" alt="Additional Image 2">
                            </div>
                            <div>
                                <img data-aos="fade-up-right" data-aos-duration="1200" data-aos-delay="200" src="<?php echo e(asset($banner->image4)); ?>" class="p-2 img-fluid" alt="Additional Image 3">
                                <img data-aos="fade-up-left" data-aos-duration="1200" data-aos-delay="200" src="<?php echo e(asset($banner->image5)); ?>" class="p-2 img-fluid" alt="Additional Image 4">
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div id="videoModal" class="modal">
                <div class="modal-content">
                    <span class="close">&times;</span>
                    
                    <?php if($gallery->display_what == 1): ?>
                    <?php echo $gallery->video_link; ?>

                    <?php elseif($gallery->display_what == 0): ?>
                    <img src="<?php echo e(asset($gallery->video_image??null)); ?>" class="img-fluid">
                    <?php endif; ?>
                    
                </div>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleCaptions" data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
        </div>
    </section>
    <!-- Hero Section End -->

    <!-- Notice Section Start -->
    <?php echo $__env->make('frontend.notice.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Notice Section End -->

    <!-- About Section Start -->
    
    <!-- About Section End -->

    <!-- Service Section Start -->
    
    <!-- Service Section End -->

    <!-- Property Section Start -->
    
    <!-- Property Section End -->

    <!-- Why Choose Us Section Start -->
    
    <!-- Why Choose Us Section End -->

    <!-- Pricing Section Start -->
    
    <!-- Pricing Section End -->

    <!-- Team Section Start -->
    
    <!-- Team Section End -->

    <!-- Testimonial Section Start -->
    
    <!-- Testimonial Section End -->

    <!-- Blog Section Start -->
    <?php echo $__env->make('frontend.blogs.blogs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Blog Section End -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('frontend_script'); ?>
<script>
    document.addEventListener('DOMContentLoaded', (event) => {
    var modal = document.getElementById("videoModal");
    var btn = document.getElementById("openVideoBtn");
    var span = document.getElementsByClassName("close")[0];
    var iframe = document.getElementById("videoFrame");
    var countdownDisplay = document.getElementById("countdownDisplay");

    btn.onclick = function() {
        modal.style.display = "flex";
        var remainingTime = 10; // in seconds
        countdownDisplay.textContent = remainingTime; // Display initial remaining time

        // Update countdown every second
        var countdownInterval = setInterval(function() {
            remainingTime--;
            countdownDisplay.textContent = remainingTime;

            // Check if time is up
            if (remainingTime <= 0) {
                clearInterval(countdownInterval);
                modal.style.display = "none";
                iframe.src = "";
            }
        }, 1000); // 1 second interval
    }

    span.onclick = function() {
        modal.style.display = "none";
        iframe.src = "";
    }

    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
            iframe.src = "";
        }
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/home/home.blade.php ENDPATH**/ ?>