<?php $__env->startSection('title'); ?>
    Blogs
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($banner->image)); ?>);">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Blog No Sidebar</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="<?php echo e(route('front.page')); ?>">Home </a></li>
                        <li>Blogs</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Blog  Section Start -->
        <div class="blog-wrap ptb-100">
            <div class="container">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="blog-card style2">
                            <div class="blog-img">
                                <img src="<?php echo e(asset($blog->main_image)); ?>" alt="Image">
                                <?php $timestamp = strtotime($blog->updated_at); $month = date('M', $timestamp);?>
                                <a href="posts-by-date.html" class="blog-date"><span><?php echo e($blog->updated_at->format('d')); ?></span><?php echo e($month); ?></a>
                            </div>
                            <div class="blog-info">
                                <h3><a href="blog-details-right-sidebar.html"><?php echo e($blog->title); ?> </a></h3>
                                <p><?php echo $blog->short_details; ?></p>
                                <a href="<?php echo e(route('blogs.details',['id'=>$blog->id])); ?>" class="link style2">Read More<i class="flaticon-right-arrow"></i></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($blogs->links()); ?>

                </div>
            </div>
        </div>
        <!-- Blog Section End -->

    </div>
    <!-- Content wrapper end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/blogs/blogs_page.blade.php ENDPATH**/ ?>