<?php $__env->startSection('title'); ?>
    Notice Details
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($banner->image)); ?>);">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Notice Details</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="<?php echo e(route('front.page')); ?>">Home </a></li>
                        <li>Notice Details</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Notice Section Start -->
        <section class="my-5">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12 text-center">
                        <div class="section-title style1 text-center mb-40">
                            <h2 style="color: #2490EB !important;"><?php echo e($notice->title??null); ?></h2>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <img src="<?php echo e(asset('notice')); ?>/<?php echo e($notice->poster??null); ?>" class="img-fluid w-100">
                    </div>
                    <div class="col-lg-6">
                        <p><?php echo $notice->description??null; ?></p>
                        <a href="" class="btn style1 rounded-0">Register</a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Notice Section End -->

        <!-- Previous Notices Start -->
        <section class="team-wrap ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-12 text-center">
                        <div class="section-title style1 text-center mb-40">
                            <h2>View Previous Notices</h2>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                        <div class="testimonial-slider-two owl-carousel text-center">
                            <?php $__empty_1 = true; $__currentLoopData = $notices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="team-card style1" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                                <div class="">
                                    <a href="<?php echo e(route('notice.details', ['id' => $notice->id])); ?>">
                                        <img data-aos="zoom-in-up" data-aos-duration="1200" data-aos-delay="200"  src="<?php echo e(asset('notice')); ?>/<?php echo e($notice->poster??null); ?>" class="img-fluid w-100">
                                        <h2 data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200" style="color: #2490EB !important;"><?php echo e($notice->title??null); ?></h2>
                                    </a>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            No Previous Notice Found!
                            <?php endif; ?>
                        </div>
                    
                </div>
            </div>
        </section>
        <!-- Previous Notices End -->

    </div>
    <!-- Content wrapper end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mbabwqrq/public_html/resources/views/frontend/notice/notice_details.blade.php ENDPATH**/ ?>