<?php $__env->startSection('title'); ?>
    Member Procedure
<?php $__env->stopSection(); ?>

<?php $__env->startPush('admin_style'); ?>
<?php echo $__env->make('admin.common.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('body'); ?>
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <form class="form-horizontal" action="<?php echo e(route('store.memberprocedure')); ?>" enctype="multipart/form-data" method="POST">
                        <?php echo csrf_field(); ?>
                        <h3>Member Procedure Information</h3>
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" name="banner_title" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Banner Image</label>
                            <input type="file" name="banner_image" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Banner Description</label>
                            <textarea id="tinymce" class="editor form-control" col="10" row="3" name="banner_description" ></textarea>
                        </div>
                        <div class="form-group">
                            <label>Registered Image</label>
                            <input type="file" name="registered_image" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Registered Description</label>
                            <textarea id="tinymce" class="editor form-control" col="10" row="3" name="registered_description" ></textarea>
                        </div>
                        <div class="form-group">
                            <label>Orientated Image</label>
                            <input type="file" name="orientated_image" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Orientated Description</label>
                            <textarea id="tinymce" class="editor form-control" col="10" row="3" name="orientated_description" ></textarea>
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                    <tr>
                        <th>Last Updated</th>
                        <th>Title</th>
                        <th>Banner Image</th>
                        <th>Registered Image</th>
                        <th>Orientated Image</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $memberprocedures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $memberprocedure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($memberprocedure->updated_at->format('d-M-Y')); ?></td>
                            <td><?php echo e($memberprocedure->banner_title); ?></td>
                            <td><img src="<?php echo e(asset($memberprocedure->banner_image)); ?>" style="height: 100px"></td>
                            <td><img src="<?php echo e(asset($memberprocedure->registered_image)); ?>" style="height: 100px"></td>
                            <td><img src="<?php echo e(asset($memberprocedure->orientated_image)); ?>" style="height: 100px"></td>
                            <td>
                                <div>
                                    <a href="<?php echo e(route('edit.memberprocedure',['id'=>$memberprocedure->id])); ?>"
                                        class="text-info" data-toggle="tooltip"
                                        data-placement="top" data-bs-original-title="Edit"><i class="fa-solid fa-pen-to-square fa-fw"></i>
                                    </a>
                                </div>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('admin_script'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.1.1/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
<?php echo $__env->make('admin.common.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\mbabd\resources\views/admin/memberprocedure/index.blade.php ENDPATH**/ ?>