<?php $__env->startSection('title'); ?>
    About
<?php $__env->stopSection(); ?>
<?php $__env->startPush('favicon'); ?>
    <?php
        $logo = \App\Models\Logo::latest()->first();
    ?>
    <link rel="icon" type="image/png" href="<?php echo e($logo ? asset($logo->logo_image) : asset('default-favicon.png')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url(<?php echo e(asset($about->banner_image??null)); ?>);">
        <div class="container">
            <div class="breadcrumb-title">
                <h2><?php echo e($about->title??null); ?></h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="<?php echo e(route('front.page')); ?>">Home</a></li>
                    <li><?php echo e($about->title??null); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- About Section Start -->
    <section class="about-wrap style1 ptb-100">
        <div class="container">
            <div class="row gx-5 align-items-center">
                <div class="col-lg-6">
                    <div class="">
                        <h4><?php echo e($about->title??null); ?></h4>
                        <p><?php echo $about->description??null; ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="">
                        <img src="<?php echo e(asset('about_photo')); ?>/<?php echo e($about->about_photo); ?>" class="img-fluid">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- About Section End -->

    <!-- Events Section Start -->
<div class="rs-gallery pt-100 pb-100 md-pt-70 md-pb-70">
    <div class="container">

        <div class="row margin-0">
            <div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2 col-md-10 offset-md-1" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                <div class="section-title style1 text-center mb-40">
                    <h2>Photo Gallery</h2>
                </div>
            </div>
            <div id="carouselExample" class="carousel slide">
                <div class="carousel-inner">
                    <?php $__currentLoopData = $galleriess; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="carousel-item <?php echo e($key == 0?'active':''); ?>">
                            <img src="<?php echo e(asset($gallery->image)); ?>" class="d-block w-100" alt="...">
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExample" data-bs-slide="prev">
                  <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                  <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselExample" data-bs-slide="next">
                  <span class="carousel-control-next-icon" aria-hidden="true"></span>
                  <span class="visually-hidden">Next</span>
                </button>
              </div>

                

        </div>
    </div>
</div>
<!-- Events Section End -->

<!-- Service Section Start -->
<section class="service-wrap ptb-100">
    <div class="container">
        <div class="row ">
            <div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2 col-md-10 offset-md-1" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                <div class="section-title style1 text-center mb-40">
                    <h2>Video Gallery</h2>
                </div>
            </div>
            <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-6 col-12">
                    <div><?php echo $gallery->video_link; ?></div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>
</section>

<!-- Service Section End -->
</div>
<!-- Content wrapper end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\mbabd\resources\views/frontend/about/about_page.blade.php ENDPATH**/ ?>