<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\ApplyController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\WebsiteController;
use App\Http\Controllers\UserPostController;
use App\Http\Controllers\RecruiterController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\ManagementController;
use App\Http\Controllers\Admin\AboutController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\Admin\ModuleController;
use App\Http\Controllers\Admin\NoticeController;
use App\Http\Controllers\Admin\ResumeController;
use App\Http\Controllers\Chat\ChatifyController;
use App\Http\Controllers\ProfileImageController;
use App\Http\Controllers\BannerAndTitleController;
use App\Http\Controllers\AppointmentInfoController;
use App\Http\Controllers\MemberProcedureController;
use App\Http\Controllers\ServiceProviderController;
use App\Http\Controllers\Trash\RoleTrashController;
use App\Http\Controllers\Trash\UserTrashController;
use App\Http\Controllers\WebsiteSettingsController;
use App\Http\Controllers\Admin\AdminLoginController;
use App\Http\Controllers\Admin\MemberRoleController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\RecruiterCompanyController;
use App\Http\Controllers\Admin\JobCircularController;
use App\Http\Controllers\CustomerDashboardController;
use App\Http\Controllers\Trash\ModuleTrashController;
use App\Http\Controllers\Admin\MerchandiserController;
use App\Http\Controllers\RecruiterDashboardController;
use App\Http\Controllers\Admin\MailToAllUserController;
use App\Http\Controllers\Admin\RecruiterListController;
use App\Http\Controllers\Trash\PermissionTrashController;
use App\Http\Controllers\Trash\JobCircularTrashController;
use App\Http\Controllers\Admin\CompanyDepartmentController;
use App\Http\Controllers\Trash\RecruiterListTrashController;
use App\Http\Controllers\Admin\ApplyController as AdminApplyController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


/*
|--------------------------------------------------------------------------
| Frontend
|--------------------------------------------------------------------------
*/

Route::get('/',[WebsiteController::class,'home'])->name('front.page');
Route::get('/notice-details/{id}', [WebsiteController::class, 'tech_web_notice_details'])->name('notice.details');
Route::get('/services-details/{id}', [WebsiteController::class, 'tech_web_services_details'])->name('services.details');
Route::get('/recruiter-page', [WebsiteController::class, 'tech_web_recruiter_details'])->name('recruiter.details');
Route::get('/memberprocedure-page', [WebsiteController::class, 'tech_web_memberprocedure_details'])->name('memberprocedure.details');
Route::get('/jobcircular-list', [WebsiteController::class, 'tech_web_jobcircular_list'])->name('jobcircular.list');
Route::get('job-details/{id}', [WebsiteController::class, 'tech_web_job_details'])->name('job.details');
Route::get('rejob-details/{id}', [WebsiteController::class, 'tech_web_rejob_details'])->name('rejob.details');
Route::get('cv_bank', [WebsiteController::class, 'tech_web_cv_bank'])->name('cv.bank');
Route::get('cv_bank-resume/{id}', [WebsiteController::class, 'tech_web_cv_bank_resume'])->name('cv_bank.resume');
Route::get('/all-services', [WebsiteController::class, 'tech_web_all_services'])->name('services');
Route::get('/about-page', [WebsiteController::class, 'tech_web_about_page'])->name('about.page');
Route::get('/mission_vission-page', [WebsiteController::class, 'tech_web_mission_vission_page'])->name('mission_vission.page');
Route::get('/team-page', [WebsiteController::class, 'tech_web_team_page'])->name('team.page');
Route::get('/management-page', [WebsiteController::class, 'tech_web_management_page'])->name('management.page');
Route::get('/testimonial-page', [WebsiteController::class, 'testimonial_page'])->name('testimonial.page');
Route::get('/appointment-page', [WebsiteController::class, 'tech_web_appointment_page'])->name('appointment.page');
Route::get('/package-page', [WebsiteController::class, 'tech_web_package_page'])->name('package.page');
Route::get('/blogs-page', [WebsiteController::class, 'tech_web_blogs_page'])->name('blogs.page');
Route::get('/blogs-details/{id}', [WebsiteController::class, 'tech_web_blogs_details'])->name('blogs.details');
Route::get('/contacts', [WebsiteController::class, 'tech_web_contacts'])->name('contacts');
Route::get('/gallery-page', [WebsiteController::class, 'tech_web_gallery_page'])->name('gallery.page');
Route::get('/video-gallery-page', [WebsiteController::class, 'tech_web_video_gallery_page'])->name('video.gallery.page');
Route::post('/store-apply', [WebsiteController::class, 'tech_web_store_apply'])->name('store.apply');
Route::get('/orientate-member', [WebsiteController::class, 'tech_web_orientate_member'])->name('orientate.member');
Route::get('/member/forum', [WebsiteController::class, 'tech_web_member_forum'])->name('member.forum');
Route::get('/member/executive', [WebsiteController::class, 'tech_web_member_executive'])->name('member.executive');
Route::get('/member/advisory', [WebsiteController::class, 'tech_web_member_advisory'])->name('member.advisory');
Route::get('/member/volunteer', [WebsiteController::class, 'tech_web_member_volunteer'])->name('member.volunteer');
Route::get('/member/presidium', [WebsiteController::class, 'tech_web_member_presidium'])->name('member.presidium');

Route::get('/message/{recipient_id}', [WebsiteController::class, 'tech_web_member_message'])->name('message.create');

// Route::get('/faq-page', [WebsiteController::class, 'tech_web_faq_page'])->name('faq.page');

//appointment start
Route::post('/appointment', [WebsiteSettingsController::class, 'tech_web_appointment'])->name('appointment');
//appointment end

//appointment start
Route::post('/contact', [WebsiteSettingsController::class, 'tech_web_contact'])->name('contact');
//appointment end

//Customer Dashboard
Route::prefix('customer/')->middleware('auth', 'is_customer')->group(function(){
    Route::get('dashboard', [ProfileController::class, 'customerDashboard'])->name('customer.dashboard');
    Route::post('customer_update', [ProfileController::class, 'customerUpdate'])->name('customer.update');
    Route::post('customer_info_store', [ProfileController::class, 'customerInfoStore'])->name('customer.info.store');
    Route::match(['post', 'put'], 'career_store_update/{id?}', [ProfileController::class, 'careerStoreOrUpdate'])->name('career.storeOrUpdate');
    Route::post('myupdate/password', [ProfileController::class, 'updatePassword'])->name('mypostupdate.password');
    Route::get('view-resume{user_id}', [ProfileController::class, 'viewResume'])->name('view.resume');

    // Route::match(['post', 'put'], 'profile-store-update/{id?}', [ProfileImageController::class, 'profileStoreOrUpdate'])->name('profile.store.update');
    Route::get('image/upload',[ProfileImageController::class, 'index']);
    Route::post('image/crop',[ProfileImageController::class, 'crop'])->name('image.crop');

    Route::get('jobhistory', [ApplyController::class, 'jobHistory'])->name('job.history');
    Route::post('applyjobstore', [ApplyController::class, 'applyJobStore'])->name('applyjob.store');
    Route::get('applyjobshow/{id}', [ApplyController::class, 'applyJobShow'])->name('applyjob.show');
    Route::post('reapplyjobstore', [ApplyController::class, 'reApplyJobStore'])->name('reapplyjob.store');
    Route::get('reapplyjobshow/{id}', [ApplyController::class, 'reApplyJobShow'])->name('reapplyjob.show');

    Route::get('blog', [UserPostController::class, 'customerBlog'])->name('customer.blog');
    Route::post('blog-store', [UserPostController::class, 'customerBlogStore'])->name('customer.blog.store');

    //Message
    Route::get('/message/view', [MessageController::class, 'view_message'])->name('message.view');
    Route::post('/message', [MessageController::class, 'store_message'])->name('message.store');

    // Route::get('fetch-messages/{senderId}', [MessageController::class, 'fetchMessages'])->name('fetch.messages');


});

//Recruiter Auth Routes
Route::prefix('recruiter/')->middleware('guest:recruiter')->group(function(){
    Route::get('/register', [RecruiterController::class, 'registerPage'])->name('register.page');
    Route::post('/register', [RecruiterController::class, 'registerStore'])->name('register.store');
    Route::get('/login', [RecruiterController::class, 'loginPage'])->name('login.page');
    Route::post('/login', [RecruiterController::class, 'loginStore'])->name('login.store');
});

//Recruiter Dashboard
Route::prefix('recruiter/')->middleware('auth:recruiter','is_recruiter')->group(function(){
    Route::get('dashboard', [RecruiterDashboardController::class, 'recruiterDashboard'])->name('recruiter.dashboard');
    Route::post('recruiter_update', [RecruiterDashboardController::class, 'recruiterUpdate'])->name('recruiter.update');
    Route::post('password', [RecruiterDashboardController::class, 'updatePassword'])->name('recruiter.update.password');
    Route::post('jobcircular', [RecruiterDashboardController::class, 'jobStore'])->name('job.store');
    Route::get('logout', [RecruiterController::class, 'recruiterLogout'])->name('recruiter.logout');

    Route::get('myjobview/{id}', [RecruiterDashboardController::class, 'myJobView'])->name('myjob.view');
    Route::get('myjobedit/{id}', [RecruiterDashboardController::class, 'myJobEdit'])->name('myjob.edit');
    Route::put('myjobupdate/{id}', [RecruiterDashboardController::class, 'myJobUpdate'])->name('myjob.update');
    Route::delete('myjobdelete/{id}', [RecruiterDashboardController::class, 'myJobDelete'])->name('myjob.delete');

    Route::get('applyjob', [RecruiterDashboardController::class, 'applyJob'])->name('applyjob.index');
    Route::get('applyjobview/{id}', [RecruiterDashboardController::class, 'applyJobView'])->name('applyjob.view');
    Route::get('applyjobedit/{id}', [RecruiterDashboardController::class, 'applyJobEdit'])->name('applyjob.edit');
    Route::put('applyjobupdate/{id}', [RecruiterDashboardController::class, 'applyJobUpdate'])->name('applyjob.update');
    Route::delete('applyjobdelete/{id}', [RecruiterDashboardController::class, 'applyJobDelete'])->name('applyjob.delete');
});


Auth::routes();


/*
|--------------------------------------------------------------------------
| Backend
|--------------------------------------------------------------------------
*/

Route::prefix('admins')->group(function(){

    Route::get('/login', [AdminLoginController::class, 'loginPage'])->name('admin.loginpage');
    Route::post('/login', [AdminLoginController::class, 'login'])->name('admin.login');
});

Route::prefix('admin')->middleware('auth', 'is_admin')->group(function(){
    Route::get('/dashboard', [HomeController::class, 'adminDashboard'])->name('admin.dashboard');
    Route::post('/logout', [AdminLoginController::class, 'adminLogout'])->name('admin.logout');

    //module start
    Route::get('module/trash', [ModuleTrashController::class, 'trash'])
    ->name('module.trash');
    Route::get('module/{module_slug}/restore', [ModuleTrashController::class, 'restore'])
    ->name('module.restore');
    Route::delete('module/{module_slug}/forcedelete', [ModuleTrashController::class, 'forceDelete'])
    ->name('module.forcedelete');
    Route::resource('module', ModuleController::class);
    //module end

    //permission start
    Route::get('permission/trash', [PermissionTrashController::class, 'trash'])
    ->name('permission.trash');
    Route::get('permission/{permission_slug}/restore', [PermissionTrashController::class, 'restore'])
    ->name('permission.restore');
    Route::delete('permission/{permission_slug}/forcedelete', [PermissionTrashController::class, 'forceDelete'])
    ->name('permission.forcedelete');
    Route::resource('permission', PermissionController::class);
    //permission end

    //role start
    Route::get('role/trash', [RoleTrashController::class, 'trash'])
    ->name('role.trash');
    Route::get('role/{role_slug}/restore', [RoleTrashController::class, 'restore'])
    ->name('role.restore');
    Route::delete('role/{role_slug}/forcedelete', [RoleTrashController::class, 'forceDelete'])
    ->name('role.forcedelete');
    Route::resource('role', RoleController::class);
    //role end

    //User Start
    Route::get('/users/trash', [UserTrashController::class, 'trash'])->name('users.trash');
    Route::get('/users/restore/{id}', [UserTrashController::class, 'restore'])
    ->name('users.restore');
    Route::delete('/users/forcedelete/{id}', [UserTrashController::class, 'forceDelete'])
    ->name('users.forcedelete');
    // //Ajax Call For User Active
    // Route::get('check/user/is_active/{user_id}', [UserController::class, 'checkActive'])
    // ->name('user.is_active.ajax');
    Route::resource('/users', UserController::class);
    //User End

    //Recruiter Start
    Route::get('/recruiters/trash', [RecruiterListTrashController::class, 'trash'])->name('recruiters.trash');
    Route::get('/recruiters/restore/{id}', [RecruiterListTrashController::class, 'restore'])
    ->name('recruiters.restore');
    Route::delete('/recruiters/forcedelete/{id}', [RecruiterListTrashController::class, 'forceDelete'])
    ->name('recruiters.forcedelete');
    Route::resource('/recruiters', RecruiterListController::class);
    //Recruiter End

    //service start
    Route::get('/add-services', [ServiceController::class, 'tech_web_add_services'])->name('add.services');
    Route::post('/store-services', [ServiceController::class, 'tech_web_store_services'])->name('store.services');
    Route::get('/edit-services/{id}', [ServiceController::class, 'tech_web_edit_services'])->name('edit.services');
    Route::post('/update-services', [ServiceController::class, 'tech_web_update_services'])->name('update.services');
    //service end

    //photo gallery start
    Route::get('/add-gallery', [GalleryController::class, 'tech_web_add_gallery'])->name('add.gallery');
    Route::post('/store-gallery', [GalleryController::class, 'tech_web_store_gallery'])->name('store.gallery');
    Route::get('/edit-gallery/{id}', [GalleryController::class, 'tech_web_edit_gallery'])->name('edit.gallery');
    Route::post('/update-gallery', [GalleryController::class, 'tech_web_update_gallery'])->name('update.gallery');
    //photo gallery end

    //video gallery start
    Route::get('/add-video-gallery', [GalleryController::class, 'tech_web_add_video_gallery'])->name('add.video.gallery');
    Route::post('/store-video-gallery', [GalleryController::class, 'tech_web_store_video_gallery'])->name('store.video.gallery');
    Route::get('/edit-video-gallery/{id}', [GalleryController::class, 'tech_web_edit_video_gallery'])->name('edit.video.gallery');
    Route::post('/update-video-gallery', [GalleryController::class, 'tech_web_update_video_gallery'])->name('update.video.gallery');
    //video gallery end

    //about start
    // Route::get('/add-about', [AboutController::class, 'tech_web_add_about'])->name('add.about');
    // Route::post('/store-about', [AboutController::class, 'tech_web_store_about'])->name('store.about');
    // Route::get('/edit-about/{id}', [AboutController::class, 'tech_web_edit_about'])->name('edit.about');
    // Route::post('/update-about', [AboutController::class, 'tech_web_update_about'])->name('update.about');
    Route::resource('about', AboutController::class);
    //about end

    //team start
    Route::get('/add-team', [TeamController::class, 'tech_web_add_team'])->name('add.team');
    Route::post('/store-team', [TeamController::class, 'tech_web_store_team'])->name('store.team');
    Route::get('/edit-team/{id}', [TeamController::class, 'tech_web_edit_team'])->name('edit.team');
    Route::post('/update-team', [TeamController::class, 'tech_web_update_team'])->name('update.team');
    //team end

    //testimonial start
    Route::get('/add-testimonial', [TestimonialController::class, 'tech_web_add_testimonial'])->name('add.testimonial');
    Route::post('/store-testimonial', [TestimonialController::class, 'tech_web_store_testimonial'])->name('store.testimonial');
    Route::get('/edit-testimonial/{id}', [TestimonialController::class, 'tech_web_edit_testimonial'])->name('edit.testimonial');
    Route::post('/update-testimonial', [TestimonialController::class, 'tech_web_update_testimonial'])->name('update.testimonial');
    //testimonial end

    //Appointment info start
    Route::get('/add-appointment-info', [AppointmentInfoController::class, 'tech_web_add_appointment_info'])->name('add.appointment.info');
    Route::post('/store-appointment-info', [AppointmentInfoController::class, 'tech_web_store_appointment_info'])->name('store.appointment.info');
    Route::get('/edit-appointment-info/{id}', [AppointmentInfoController::class, 'tech_web_edit_appointment_info'])->name('edit.appointment.info');
    Route::post('/update-appointment-info', [AppointmentInfoController::class, 'tech_web_update_appointment_info'])->name('update.appointment.info');
    //Appointment info end


    //package start
    Route::get('/add-package', [PackageController::class, 'tech_web_add_package'])->name('add.package');
    Route::post('/store-package', [PackageController::class, 'tech_web_store_package'])->name('store.package');
    Route::get('/edit-package/{id}', [PackageController::class, 'tech_web_edit_package'])->name('edit.package');
    Route::post('/update-package', [PackageController::class, 'tech_web_update_package'])->name('update.package');
    //package end

    //Blogs start
    Route::get('/add-blogs', [BlogController::class, 'tech_web_add_blogs'])->name('add.blogs');
    Route::post('/store-blogs', [BlogController::class, 'tech_web_store_blogs'])->name('store.blogs');
    Route::get('/edit-blogs/{id}', [BlogController::class, 'tech_web_edit_blogs'])->name('edit.blogs');
    Route::post('/update-blogs', [BlogController::class, 'tech_web_update_blogs'])->name('update.blogs');
    Route::delete('/delete-blogs/{id}', [BlogController::class, 'tech_web_delete_blogs'])->name('delete.blogs');
    //Blogs end

    //Management start
    Route::get('/add-management', [ManagementController::class, 'tech_web_add_management'])->name('add.management');
    Route::post('/store-management', [ManagementController::class, 'tech_web_store_management'])->name('store.management');
    Route::get('/edit-management/{id}', [ManagementController::class, 'tech_web_edit_management'])->name('edit.management');
    Route::post('/update-management', [ManagementController::class, 'tech_web_update_management'])->name('update.management');
    //Management end

    //Banner and Tile
    Route::post('/store-banner-title', [BannerAndTitleController::class, 'tech_web_store_banner_tile'])->name('store.banner.title');
    Route::get('/edit-banner-title/{id}', [BannerAndTitleController::class, 'tech_web_edit_banner_tile'])->name('edit.banner.title');
    Route::post('/update-banner-title/{id}', [BannerAndTitleController::class, 'tech_web_update_banner_tile'])->name('update.banner.title');
    //Banner and title

    //Logo start
    Route::post('/store-logo', [WebsiteSettingsController::class, 'tech_web_store_logo'])->name('store.logo');
    //Logo end

    //links start
    Route::post('/store-links', [WebsiteSettingsController::class, 'tech_web_store_links'])->name('store.links');
    //Links end

    //counter start
    Route::post('/store-counter', [WebsiteSettingsController::class, 'tech_web_store_counter'])->name('store.counter');
    //counter end

    //footer start
    Route::post('/store-footer', [WebsiteSettingsController::class, 'tech_web_store_footer'])->name('store.footer');

    //footer end

    //banner start
    Route::post('/store-main-banner', [WebsiteSettingsController::class, 'tech_web_store_main_banner'])->name('store.main.banner');
    Route::get('/edit-main-banner/{id}', [WebsiteSettingsController::class, 'tech_web_edit_main_banner'])->name('edit.main.banner');
    Route::post('/update-main-banner/{id}', [WebsiteSettingsController::class, 'tech_web_update_main_banner'])->name('update.main.banner');
    //banner end


    //general settings start
    Route::get('/general-settings', [GeneralController::class, 'tech_web_general_settings'])->name('general.settings');
    //general settings end

    //profile settings start
    Route::get('/profile-settings', [GeneralController::class, 'tech_web_profile_settings'])->name('profile.settings');
    Route::get('/profileimage-settings', [GeneralController::class, 'tech_web_profileimage_settings'])->name('profileimage.settings');
    Route::post('/store-profile', [GeneralController::class, 'tech_web_store_profile'])->name('admin.store.profile');
    Route::post('/update-profile', [GeneralController::class, 'tech_web_update_profile'])->name('admin.update.profile');
    //profile settings end

    //faq start
    // Route::get('/add-faq', [FaqController::class, 'tech_web_add_faq'])->name('add.faq');
    // Route::post('/store-faq', [FaqController::class, 'tech_web_store_faq'])->name('store.faq');
    // Route::get('/edit-faq/{id}', [FaqController::class, 'tech_web_edit_faq'])->name('edit.faq');
    // Route::post('/update-faq', [FaqController::class, 'tech_web_update_faq'])->name('update.faq');
    //faq end


    //recruiter start
    Route::get('/list-recruiter', [RecruiterCompanyController::class, 'tech_web_list_recruiter'])->name('list.recruiter');
    Route::post('/store-recruiter', [RecruiterCompanyController::class, 'tech_web_store_recruiter'])->name('store.recruiter');
    Route::get('/edit-recruiter/{id}', [RecruiterCompanyController::class, 'tech_web_edit_recruiter'])->name('edit.recruiter');
    Route::post('/update-recruiter', [RecruiterCompanyController::class, 'tech_web_update_recruiter'])->name('update.recruiter');
    //recruiter end

    //memberprocedure start
    Route::get('/list-memberprocedure', [MemberProcedureController::class, 'tech_web_list_memberprocedure'])->name('list.memberprocedure');
    Route::post('/store-memberprocedure', [MemberProcedureController::class, 'tech_web_store_memberprocedure'])->name('store.memberprocedure');
    Route::get('/edit-memberprocedure/{id}', [MemberProcedureController::class, 'tech_web_edit_memberprocedure'])->name('edit.memberprocedure');
    Route::post('/update-memberprocedure', [MemberProcedureController::class, 'tech_web_update_memberprocedure'])->name('update.memberprocedure');
    //memberprocedure end

    //company start
    Route::get('/list-company', [CompanyController::class, 'tech_web_list_company'])->name('list.company');
    Route::post('/store-company', [CompanyController::class, 'tech_web_store_company'])->name('store.company');
    Route::get('/edit-company/{id}', [CompanyController::class, 'tech_web_edit_company'])->name('edit.company');
    Route::post('/update-company', [CompanyController::class, 'tech_web_update_company'])->name('update.company');
    Route::delete('/delete-company/{id}', [CompanyController::class, 'tech_web_delete_company'])->name('delete.company');
    //company end

    //product start
    Route::get('/list-product', [ProductController::class, 'tech_web_list_product'])->name('list.product');
    Route::post('/store-product', [ProductController::class, 'tech_web_store_product'])->name('store.product');
    Route::get('/edit-product/{id}', [ProductController::class, 'tech_web_edit_product'])->name('edit.product');
    Route::post('/update-product', [ProductController::class, 'tech_web_update_product'])->name('update.product');
    Route::delete('/delete-product/{id}', [ProductController::class, 'tech_web_delete_product'])->name('delete.product');
    //product end

    //job circular start
    Route::get('/jobcircular/trash', [JobCircularTrashController::class, 'trash'])->name('jobcircular.trash');
    Route::get('/jobcircular/restore/{id}', [JobCircularTrashController::class, 'restore'])
    ->name('jobcircular.restore');
    Route::delete('/jobcircular/forcedelete/{id}', [JobCircularTrashController::class, 'forceDelete'])
    ->name('jobcircular.forcedelete');
    Route::get('rejobcircularview/{id}', [JobCircularController::class, 'rejobcircularView'])
    ->name('rejobcircular.view');
    Route::resource('jobcircular', JobCircularController::class);
    //job circular end

    // //resume start
    // Route::resource('resume', ResumeController::class);
    // //resume end

    //companydepartment start
    Route::resource('companydepartment', CompanyDepartmentController::class);
    //companydepartment end

    //apply start
    Route::get('reapplyview/{id}', [AdminApplyController::class, 'reapplyView'])->name('reapply.view');
    Route::resource('apply', AdminApplyController::class);
    //apply end

    //notice start
    Route::resource('notices', NoticeController::class);
    //notice end

    //Member Role Start
    Route::resource('member_role', MemberRoleController::class);
    //Member Role End

    //Merchandiser Role Start
    Route::resource('merchandiser', MerchandiserController::class);
    //Merchandiser Role End

    //MailToAllUser Role Start
    Route::resource('mails', MailToAllUserController::class);
    //MailToAllUser Role End
});







