@extends('frontend.master')
@section('title')
    Service Provider
@endsection
@section('content')

    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap mb-5 bg-f" style="background-image: url({{asset($banner->image)}});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Service Provider</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{route('front.page')}}">Home </a></li>
                        <li>Service Provider</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <section class="wh-wrap style2 pb-100">
            <div class="container">
                <div class="row gx-5 align-items-center text-end">
                    <div class="col-lg-6" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                        <div class="wh-content">
                            <div class="content-title style1">
                                <h1>Your Partner in Property Maintenance</h1>
                                <p>Are you a skilled service professional looking to expand your business opportunities in the property maintenance industry? Look no further!</p>
                            </div>
                            <a href="#serviceprovider" class="btn style7">Join today</a>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="image_area">
                            <img src="{{ asset('serviceprovider') }}/Service-provider.png" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="wh-wrap style2 pb-100 mb-4">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-4">
                        <div class="book-appointment-form h-100">
                            <div class="feature-item-wrap">
                                <div class="feature-item">
                                    <div class="feature-icon text-icon">
                                        <i class="fa-solid fa-check"></i>
                                    </div>
                                </div>
                                <h4>Reliable Payment</h4>
                                <p>Say goodbye to late payments and unpredictable income. We pride ourselves on prompt and fair compensation for your services.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="book-appointment-form h-100">
                            <div class="feature-item-wrap">
                                <div class="feature-item">
                                    <div class="feature-icon text-icon">
                                        <i class="fa-regular fa-calendar"></i>
                                    </div>
                                </div>
                                <h4>Efficient Scheduling & Communication</h4>
                                <p>Our efficient scheduling system enhances productivity. As a Home365 Vendor, you'll access the Vendor App to bid, view maintenance project videos, and deposit funds to your bank account.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="book-appointment-form h-100">
                            <div class="feature-item-wrap">
                                <div class="feature-item">
                                    <div class="feature-icon text-icon">
                                        <i class="fa-solid fa-person"></i>
                                    </div>
                                </div>
                                <h4>Market Exposure</h4>
                                <p>Partnering with us provides exposure to a wider client base, boosting your reputation and customer trust. You can also reduce the time and money spent on marketing your services, as we bring clients directly to you.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 mt-4">
                        <div class="book-appointment-form h-100">
                            <div class="feature-item-wrap">
                                <div class="feature-item">
                                    <div class="feature-icon text-icon">
                                        <i class="fa-solid fa-headset"></i>
                                    </div>
                                </div>
                                <h4>Professional Support</h4>
                                <p>We have a dedicated support team available to assist with any questions or issues, making your partnership experience smooth and stress-free.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 mt-4">
                        <div class="book-appointment-form h-100">
                            <div class="feature-item-wrap">
                                <div class="feature-item">
                                    <div class="feature-icon text-icon">
                                        <i class="fa-solid fa-business-time"></i>
                                    </div>
                                </div>
                                <h4>Business Growth</h4>
                                <p>Joining our network can lead to significant business growth as you tap into a steady stream of projects.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 mt-4">
                        <div class="book-appointment-form h-100">
                            <div class="feature-item-wrap">
                                <div class="feature-item">
                                    <div class="feature-icon text-icon">
                                        <i class="fa-solid fa-screwdriver-wrench"></i>
                                    </div>
                                </div>
                                <h4>Diverse Project Portfolio</h4>
                                <p>We offer a wide variety of property types and maintenance tasks, keeping your work exciting and challenging.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Service Provider Section Start -->
        <section id="serviceprovider" class="service-wrap ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        @if(session('message'))
                            <div class="alert alert-success" role="alert">
                                {{session('message')}}
                            </div>
                        @endif
                        <form class="book-appointment-form mt-5" action="{{ route('store.serviceprovider') }}" enctype="multipart/form-data" method="POST">
                            @csrf
                            <div class="content-title">
                                <h4>Ready to Join Us?</h4>
                                <h6>Fill out the form below</h6>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label class="form-label">Company name (if applicable)</label>
                                        <input type="text" class="form-control" rows="5" name="company_name" id="company_name" placeholder="Company Name">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label class="form-label">First Name</label>
                                        <input type="text" class="form-control" rows="5" name="first_name" id="first_name" placeholder="First Name">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label class="form-label">Last Name</label>
                                        <input type="text" class="form-control" rows="5" name="last_name" id="last_name" placeholder="Last Name">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label class="form-label">Phone</label>
                                        <input type="text" class="form-control" rows="5" name="phone" id="phone" placeholder="Phone">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label class="form-label">Email</label>
                                        <input type="email" class="form-control" rows="5" name="email" id="email" placeholder="Email">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label class="form-label">Street Address</label>
                                        <input type="text" class="form-control" rows="5" name="street_address" id="street_address" placeholder="Street Address">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label class="form-label">City</label>
                                        <input type="text" class="form-control" rows="5" name="city" id="city" placeholder="City">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label class="form-label">State</label>
                                        <input type="text" class="form-control" rows="5" name="state" id="state" placeholder="State">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label class="form-label">Base Region</label>
                                        <select name="base_region" id="base_region" class="form-select">
                                            <option selected>Please Select</option>
                                            <option value="1">Phoenix, AZ</option>
                                            <option value="2">Atlanta, GA</option>
                                            <option value="3">Chicago, IL</option>
                                            <option value="4">Baltimore, MD</option>
                                            <option value="5">Detroit, MI</option>
                                            <option value="6">Trenton, NJ</option>
                                            <option value="7">Las Vegas, NV</option>
                                            <option value="8">Central PA</option>
                                            <option value="9">Lehigh Valley, PA</option>
                                            <option value="10">Philadelphia, PA</option>
                                            <option value="11">Pittsburgh, PA</option>
                                            <option value="12">Reading, PA</option>
                                            <option value="13">Scranton, PA</option>
                                            <option value="14">Norfolk, VA</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label class="form-label">Radius in Miles</label>
                                        <input type="number" class="form-control" name="radius_in_mile" id="radius_in_mile" placeholder="State">
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <label><h6>Service Categories</h6></label>
                                    <p>Please only select the categories that are relevant to you. </p>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_airductcleaning" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Air Duct Cleaning</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_appliance" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Appliance/ Repair</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_carpetcleaner" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Carpet Cleaner</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_cleaner" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Cleaner</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_commonareacleaning" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Common Area Cleaning</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_damage" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Damage Restoration</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_electrician" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Electrician</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_exterminator" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Exterminator</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_fireplaceservices" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Fireplace Services</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_flooring" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Flooring</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_fullturnover" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Full Turnover</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_garagedoor" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Garage Door Installer/ Repair</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_gardener" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Gardener and Landscape Architect</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_generalcontractor" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">General Contractor</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_glassandmirrors" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Glass and Mirrors</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_handyman" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Handyman</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_homeinspector" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Home Inspector</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_hvac" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">HVAC</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_lawncare" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Lawn Care</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_leadinspection" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Lead Inspection</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_lockchange" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Lock Change</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_locksmith" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Locksmith</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_moldremediation" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Mold Remediation</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_noheat" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">No Heat</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_painter" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Painter</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_plumber" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Plumber</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_plumberwater" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Plumber (Water Heater)</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_poolcleaning" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Pool Cleaning</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_poolmaintenance" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Pool Maintenance</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_poolrepair" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Pool/ Hot Tub Installer/ Repair</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_repair" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Repairs</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_roofer" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Roofer</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_secinspector" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Sec - 8 Inspector</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_sewagebackup" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Sewage Back Up</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_sewagecleanup" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Sewage Cleanup</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_snowremoval" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Snow Removal</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" name="is_tilecontractor" type="checkbox" role="switch" id="activeStatus">
                                        <label class="form-check-label" for="activeStatus">Tile Contractor</label>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label>Vendor W9</label>
                                        <input type="file" name="vendor_w9_image" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label>Vendor COI (copy of liability insurance)</label>
                                        <input type="file" name="vendor_col_image" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label>Vendor certification/ licences</label>
                                        <input type="file" name="vendor_certification_image" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <button type="submit" class="btn style1 rounded-0">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <!-- Service Provider Section End -->

        <section class="wh-wrap style2 pb-100 mb-4">
            <div class="container">
                <div class="row gx-5 align-items-center">
                    <div class="col-lg-6">
                        <div class="image_area">
                            <img src="{{ asset('serviceprovider') }}/text-img-13.png" alt="">
                        </div>
                    </div>
                    <div class="col-lg-6" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                        <div class="wh-content">
                            <div class="content-title style1">
                                <p>At Home365, we value our vendor partnerships and are always looking for talented professionals to join our team. If you're ready to take your property maintenance business to the next level and enjoy the benefits of a stable and rewarding partnership, fill out our vendor information request form today.
                                    <br> <br>Partner with us and be part of a thriving community of service professionals dedicated to delivering top-notch property maintenance solutions. Together, we can make properties safer, more efficient, and more beautiful.</p>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>
    <!-- Content wrapper end -->
@endsection

