@extends('frontend.master')
@section('title')
    Recruiter Register
@endsection
@push('favicon')
    @php $logo = \App\Models\Logo::latest()->first() @endphp
    <link rel="icon" type="image/png" href="{{asset($logo->logo_image)}}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<style>
    .password-wrapper {
        position: relative;
    }

    .toggle-password {
        position: absolute;
        top: 70%;
        right: 20px;
        transform: translateY(-50%);
        cursor: pointer;
    }

    .toggle-password i {
        color: #2490EB; /* Adjust color as needed */
    }

    .toggle-password.active i {
        color: #007bff; /* Color when active, adjust as needed */
    }

</style>
@endpush
@section('content')

<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Recruiter Register</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home </a></li>
                    <li>Recruiter Register</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Recruiter Login Form Start -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2 col-12">
                    <div class="login-form-wrap">
                        <div class="login-header">
                            <h3>Recruiter Registration Form</h3>
                            @if(session('error'))
                            <p class="text-danger">{{session('error')}}</p>
                            @endif
                        </div>
                        <form action="{{ route('register.store') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label>User Name <span class="text-danger">*</span></label>
                                        <input type="text" name="name" class="form-control py-3 rounded-0 @error('name') is-invalid @enderror"
                                        value="{{ old('name') }}">
                                        @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label>User Phone <span class="text-danger">*</span></label>
                                        <input type="tel" name="phone" class="form-control py-3 rounded-0 @error('phone') is-invalid @enderror"
                                        value="{{ old('phone') }}">
                                        @error('phone')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <div class="form-group">
                                        <label>Email Address <span class="text-danger">*</span></label>
                                        <input type="email" name="email" class="form-control py-3 rounded-0 @error('email') is-invalid @enderror"
                                        value="{{ old('email') }}">
                                        @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <p>Designation <span class="text-danger">*</span></p>
                                        <input type="text" name="designation" class="form-control py-3 rounded-0 @error('designation') is-invalid @enderror"
                                        value="{{ old('designation') }}">
                                        @error('designation')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <p>Company Name <span class="text-danger">*</span></p>
                                        <input type="text" name="company_name" class="form-control py-3 rounded-0 @error('company_name') is-invalid @enderror"
                                        value="{{ old('company_name') }}">
                                        @error('company_name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-group password-wrapper">
                                        <p>Password <span class="text-danger">*</span></p>
                                        <input type="Password" name="password" class="form-control py-3 rounded-0 @error('password') is-invalid @enderror">
                                        <span class="toggle-password">
                                            <i class="fa-solid fa-eye" id="togglePassword"></i>
                                        </span>
                                        @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-group password-wrapper">
                                        <p>Confirm Password <span class="text-danger">*</span></p>
                                        <input type="Password" name="password_confirmation" class="form-control py-3 rounded-0 @error('password_confirmation') is-invalid @enderror">
                                        <span class="toggle-password">
                                            <i class="fa-solid fa-eye" id="toggleConfirmPassword"></i>
                                        </span>
                                        @error('password_confirmation')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <div class="form-group">
                                        <button type="submit" class="btn style1 rounded-0 w-100">REGISTER</button>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <a href="{{ route('login.page') }}">Or Sign In</a>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <!-- Recruiter Login Form End -->


</div>
<!-- Content wrapper end -->
@endsection
@push('frontend_script')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var passwordField = document.querySelector('input[name="password"]');
        var confirmPasswordField = document.querySelector('input[name="password_confirmation"]');
        var togglePassword = document.getElementById('togglePassword');
        var toggleConfirmPassword = document.getElementById('toggleConfirmPassword');

        togglePassword.addEventListener('click', function() {
            var type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);
            togglePassword.classList.toggle('active');
            if (type === 'text') {
                togglePassword.classList.remove('fa-eye');
                togglePassword.classList.add('fa-eye-slash');
            } else {
                togglePassword.classList.remove('fa-eye-slash');
                togglePassword.classList.add('fa-eye');
            }
        });

        toggleConfirmPassword.addEventListener('click', function() {
            var type = confirmPasswordField.getAttribute('type') === 'password' ? 'text' : 'password';
            confirmPasswordField.setAttribute('type', type);
            toggleConfirmPassword.classList.toggle('active');
            if (type === 'text') {
                toggleConfirmPassword.classList.remove('fa-eye');
                toggleConfirmPassword.classList.add('fa-eye-slash');
            } else {
                toggleConfirmPassword.classList.remove('fa-eye-slash');
                toggleConfirmPassword.classList.add('fa-eye');
            }
        });
    });
</script>
@endpush