@extends('frontend.master')
@section('title')
    Recruiter Dashboard
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .text_custom {
        color: #2490EB !important;
    }
</style>
@endpush
@section('content')
<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Recruiter Information</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home </a></li>
                    <li>Recruiter Information</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Recruiter Dashboard Start -->
    <div class="container py-5">
        <div class="book-appointment-form h-100 overflow-hidden">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2 class="font-weight-bold py-3 mb-4">Account settings</h2>
                        <h4 class="text_custom">Welcome Back, {{ Auth::guard('recruiter')->user()->name }}!</h4>
                    </div>
                </div>
                <div class="col-md-3 pt-0">
                    <div class="list-group profile_setting">
                        <a class="list-group-item active py-3" data-toggle="list"
                            href="#account-general">General</a>
                        <a class="list-group-item py-3" data-toggle="list"
                            href="#account-change-password">Change password</a>
                        <a class="list-group-item py-3" data-toggle="list"
                            href="#recruiter-jobcircular">Publish a New Job Circular</a>
                        <a class="list-group-item py-3" href="{{ route('applyjob.index') }}">My Job Circular History</a>
                        <a class="list-group-item py-3" href="{{ route('recruiter.logout') }}">Logout</a>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="account-general">
                            <div class="card-body media align-items-center">
                                <h4>General Setting</h4>
                                @if ($recruiter->company_logo??null)
                                    <img src="{{ asset($recruiter->company_logo??null) }}" style="width: 200px; height: 200px; border-radius: 50%;">
                                @else
                                    <img src="{{ asset('profile/default_profile.png') }}" style="width: 200px; height: 200px; border-radius: 50%;">
                                @endif
                                <form action="{{ route('recruiter.update') }}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $recruiter->id }}">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="name" class="form-label">Username</label>
                                                <input type="text" name="name" class="form-control rounded-0" value="{{ $recruiter->name??null }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="phone" class="form-label">Phone</label>
                                                <input type="tel" name="phone" class="form-control rounded-0" value="{{ $recruiter->phone??null }}">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="email" class="form-label">Email</label>
                                                <input type="email" name="email" class="form-control rounded-0" value="{{ $recruiter->email??null }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="designation" class="form-label">Designation</label>
                                                <input type="designation" name="designation" class="form-control rounded-0" value="{{ $recruiter->designation??null }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="company_name" class="form-label">Company Name</label>
                                                <input type="company_name" name="company_name" class="form-control rounded-0" value="{{ $recruiter->company_name??null }}">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group mb-3">
                                                <label for="address" class="form-label">Address</label>
                                                <textarea class="form-control rounded-0" name="address" col="10" rows="5">{{ $recruiter->address??null }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="company_logo" class="form-label">Profile Image</label>
                                                <input type="file" name="company_logo" class="form-control rounded-0">
                                            </div>
                                        </div>

                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="account-change-password">
                            <div class="card-body pb-2">
                                <h4>Password Setting</h4>
                                <form action="{{ route('recruiter.update.password') }}" method="POST">
                                    @csrf
                                    <div class="form-group mb-3">
                                        <label for="old_password" class="form-label">Current password</label>
                                        <input type="password" name="old_password" class="form-control rounded-0">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="password" class="form-label">New password</label>
                                        <input type="password" name="password" class="form-control rounded-0">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="password_confirmation" class="form-label">Repeat new password</label>
                                        <input type="password" name="password_confirmation" class="form-control rounded-0">
                                    </div>
                                    <div class="form-group mb-3">
                                        <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                    </div>
                                </form>

                            </div>
                        </div>
                        <div class="tab-pane fade" id="recruiter-jobcircular">
                            <div class="card-body pb-2">
                                @if(Auth::guard('recruiter')->user()->is_recruiter == 1 && Auth::guard('recruiter')->user()->is_approved == 1)
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <strong>Congratulation! !! Now you can publish your job circular.</strong>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                <form class="form-horizontal" action="{{ route('job.store') }}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            {{-- <input type="hidden" name="recruiter_id" value="{{ Auth::guard('recruiter')->id() }}"> --}}
                                            <div class="form-group mb-3">
                                                <label for="department_id" class="form-label mb-2">Select Department <span class="text-danger">*</span></label>
                                                <select id="defaultSelect" name="department_id"
                                                    class="form-select
                                                @error('department_id')
                                                    is-invalid
                                                @enderror">
                                                    <option selected>Choose a Department</option>
                                                    @forelse ($departments as $department)
                                                        <option value="{{ $department->id }}">{{ $department->company_department_name }}</option>
                                                    @empty
                                                    @endforelse
                                                </select>
                                                @error('department_id')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="company_id" class="form-label mb-2">Select Comapny <span class="text-danger">*</span></label>
                                                <select id="defaultSelect" name="company_id"
                                                    class="form-select
                                                @error('company_id')
                                                    is-invalid
                                                @enderror">
                                                    <option selected>Choose Company Type</option>
                                                    @forelse ($companies as $company)
                                                        <option value="{{ $company->id }}">{{ $company->company_name }}</option>
                                                    @empty
                                                    @endforelse
                                                </select>
                                                @error('company_id')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="producttype_id" class="form-label mb-2">Select Product Type <span class="text-danger">*</span></label>
                                                <select id="defaultSelect" name="producttype_id"
                                                    class="form-select
                                                @error('producttype_id')
                                                    is-invalid
                                                @enderror">
                                                    <option selected>Choose a Product</option>
                                                    @forelse ($producttypes as $producttype)
                                                        <option value="{{ $producttype->id }}">{{ $producttype->product_name }}</option>
                                                    @empty
                                                    @endforelse
                                                </select>
                                                @error('producttype_id')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="job_title" class="form-label mb-2">Job Title<span class="text-danger">*</span></label>
                                                <input type="text" class="form-control @error('job_title')
                                                is-invalid
                                                @enderror" rows="5" name="job_title" value="{{ old('job_title') }}" id="job_title" placeholder="Designation">
                                                @error('job_title')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group mb-3">
                                                <label for="company_nam" class="form-label mb-2">Company Name <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control @error('company_nam')
                                                is-invalid
                                                @enderror" rows="5" name="company_nam" value="{{ old('company_nam') }}" id="company_nam">
                                                @error('company_nam')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="vacancy" class="form-label mb-2">Vacancy <span class="text-danger">*</span></label>
                                                <input type="number" placeholder="number of post 1,2,3......." class="form-control @error('vacancy')
                                                is-invalid
                                                @enderror" rows="5" name="vacancy" value="{{ old('vacancy') }}" id="vacancy">
                                                @error('vacancy')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="job_banner" class="form-label mb-2">Job Thumbnail</label>
                                                <input type="file" class="form-control @error('job_banner')
                                                is-invalid
                                                @enderror" rows="5" name="job_banner" value="{{ old('job_banner') }}" id="job_banner">
                                                @error('job_banner')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group mb-3">
                                                <label for="responsibilities" class="form-label mb-2">Responsibilities</label>
                                                <textarea id="tinymce" class="editor form-control @error('responsibilities')
                                                is-invalid
                                                @enderror" col="10" row="3" name="responsibilities" >{{ old('responsibilities') }}</textarea>
                                            </div>
                                            @error('responsibilities')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group mb-3">
                                                <label for="experience" class="form-label mb-2">Experience <span class="text-danger">*</span></label>
                                                <textarea id="tinymce" class="editor form-control @error('experience')
                                                is-invalid
                                                @enderror" col="10" row="3" name="experience" >{{ old('experience') }}</textarea>
                                            </div>
                                            @error('experience')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group mb-3">
                                                <label for="location" class="form-label mb-2">Location <span class="text-danger">*</span></label>
                                                <textarea id="tinymce" class="editor form-control @error('location')
                                                is-invalid
                                                @enderror" col="10" row="3" name="location" >{{ old('location') }}</textarea>
                                            </div>
                                            @error('location')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="qualification" class="form-label mb-2">Qualification</label>
                                                <input type="text" class="form-control @error('qualification')
                                                is-invalid
                                                @enderror" rows="5" name="qualification" value="{{ old('qualification') }}" id="qualification">
                                                @error('qualification')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="salary_range" class="form-label mb-2">Salary Range</label>
                                                <input type="text" class="form-control @error('salary_range')
                                                is-invalid
                                                @enderror" rows="5" name="salary_range" value="{{ old('salary_range') }}" id="salary_range">
                                                @error('salary_range')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="others_facilities" class="form-label mb-2">Others Facilities</label>
                                                <input type="text" class="form-control @error('others_facilities')
                                                is-invalid
                                                @enderror" rows="5" name="others_facilities" value="{{ old('others_facilities') }}" id="others_facilities">
                                                @error('others_facilities')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="company_logo" class="form-label mb-2">Company Logo</label>
                                                <input type="file" class="form-control @error('company_logo')
                                                is-invalid
                                                @enderror" rows="5" name="company_logo" value="{{ old('company_logo') }}" id="company_logo">
                                                @error('company_logo')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="deadline_till" class="form-label mb-2">Dead Line</label>
                                                <input type="date" class="form-control @error('deadline_till')
                                                is-invalid
                                                @enderror" rows="5" name="deadline_till" value="{{ old('deadline_till') }}">
                                                @error('deadline_till')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="table-responsive">
                                            <button type="submit" class="btn btn-info">Submit</button>
                                        </div>
                                    </div>
                                </form>
                                @else
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <strong>Sorry! You are not allowed to publish your job posting. Please wait for administration's response.</strong>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Recruiter Dashboard End -->

    <!-- Job Application Start -->
    <!-- Job Application End -->


</div>
<!-- Content wrapper end -->
@endsection

@push('frontend_script')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
{{-- <script src="https://cdn.datatables.net/2.0.3/js/dataTables.bootstrap5.js"></script> --}}
<script>
    @if(Session::has('message'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("{{ session('message') }}");
    @endif

    @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("{{ session('error') }}");
    @endif

    @if(Session::has('info'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("{{ session('info') }}");
    @endif

    @if(Session::has('warning'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("{{ session('warning') }}");
    @endif
</script>
@endpush
