@extends('frontend.master')
@section('title')
    Recruiter Company
@endsection
@push('favicon')
    @php $logo = \App\Models\Logo::latest()->first() @endphp
    <link rel="icon" type="image/png" href="{{asset($logo->logo_image)}}">
@endpush
@section('content')

<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Recruiter Company</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home </a></li>
                    <li>Recruiter Company</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Service Details section Start -->
    <section class="service-details-wrap ptb-100">
        <div class="container">
            <div class="row gx-5">
                <div class="col-md-12 col-lg-6">
                    <h2>{{ $recruiter->title??null }}</h2>
                    <p>{!! $recruiter->description??null !!}</p>
                    <div>
                        @auth('recruiter')
                            <a href="{{ route('recruiter.dashboard') }}" class="btn style1 rounded-0">My Account</a>
                            <a href="{{ route('applyjob.index') }}" class="btn style1 rounded-0">My Job Circular History</a>
                        @endauth

                        @guest('recruiter')
                            <a href="{{ route('login.page') }}" class="btn style1 rounded-0">Sign In</a>
                            <a href="{{ route('register.page') }}" class="btn style1 rounded-0">Sign Up</a>
                        @endguest

                    </div>
                </div>
                <div class="col-md-12 col-lg-6 mt-4 mt-lg-0">
                    <img src="{{asset($recruiter->recruiter_photo??null)}}" class="img-fluid" alt="">
                </div>
            </div>
        </div>
    </section>
    <!-- Service Details section End -->


</div>
<!-- Content wrapper end -->
@endsection
