@extends('frontend.master')
@section('title')
 {{ $rejobcircular->job_title }}
@endsection
@push('favicon')
    <link rel="icon" type="image/png" href="{{ asset('jobcircular') }}/{{ $rejobcircular->company_logo }}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.3/css/dataTables.bootstrap5.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .text_custom {
        color: #2490EB !important;
    }
    .btn_custom {
        background-color: transparent;
        border: none;
    }
</style>
@endpush
@section('content')
<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>My Job Details</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home </a></li>
                    <li>My Job Details</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Job List Start -->
    <div class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 login-form-wrap">
                    <div class="d-flex justify-content-between mb-4 align-items-center">
                        <h1>View Details</h1>
                        <a href="{{ route('applyjob.index') }}" class="btn style1 rounded-0">Go Back</a>
                    </div>
                    <table class="table table-striped table-bordered table-hover">
                        <tbody>
                            <tr>
                                <th><h3>Publisher</h3></th>
                                <td><h3>{{ $rejobcircular->recruiter->name }}</h3></td>
                            </tr>
                            <tr>
                                <th>Job Title</th>
                                <td>{{ $rejobcircular->job_title }}</td>
                            </tr>
                            <tr>
                                <th>Company Logo</th>
                                <td>
                                    <img src="{{ asset('jobcircular') }}/{{ $rejobcircular->company_logo }}"
                                    class="" alt="" style="height:100px;">
                                </td>
                            </tr>
                            <tr>
                                <th>Thumbnail</th>
                                <td>
                                    <img src="{{ asset('jobcircular') }}/{{ $rejobcircular->job_banner }}"
                                    class="" alt="" style="height:100px;">
                                </td>
                            </tr>
                            <tr>
                                <th>Company Name</th>
                                <td>{{ $rejobcircular->company_nam }}</td>
                            </tr>
                            <tr>
                                <th>Company Type</th>
                                <td>{{ $rejobcircular->company->company_name }}</td>
                            </tr>
                            <tr>
                                <th>Department</th>
                                <td>{{ $rejobcircular->department->company_department_name }}</td>
                            </tr>
                            <tr>
                                <th>Product Type</th>
                                <td>{{ $rejobcircular->productType->product_name }}</td>
                            </tr>
                            <tr>
                                <th>Vacancy</th>
                                <td>{{ $rejobcircular->vacancy }}</td>
                            </tr>
                            <tr>
                                <th>Responsibilities</th>
                                <td>{!! $rejobcircular->responsibilities !!}</td>
                            </tr>
                            <tr>
                                <th>Experience</th>
                                <td>{!! $rejobcircular->experience !!}</td>
                            </tr>
                            <tr>
                                <th>Qualification</th>
                                <td>{{ $rejobcircular->qualification }}</td>
                            </tr>
                            <tr>
                                <th>Others Facilities</th>
                                <td>{{ $rejobcircular->others_facilities }}</td>
                            </tr>
                            <tr>
                                <th>Salary Range</th>
                                <td>{{ $rejobcircular->salary_range }}</td>
                            </tr>
                            <tr>
                                <th>Location</th>
                                <td>{!! $rejobcircular->location !!}</td>
                            </tr>
                            <tr>
                                <th>Dead Line</th>
                                @if($rejobcircular->deadline_till >= now())
                                    <td><span class="badge text-bg-success">{{ $rejobcircular->deadline_till }}</span></td>
                                @else
                                    <td><span class="badge text-bg-danger">Expired</span></td>
                                @endif
                            </tr>
                            <tr>
                                <th>Created Date</th>
                                <td>{{ $rejobcircular->created_at->format('d-M-Y') }}</td>
                            </tr>
                            <tr>
                                <th>Last Updated</th>
                                <td>{{ $rejobcircular->updated_at->format('d-M-Y') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Job List End -->

</div>
<!-- Content wrapper end -->
@endsection

@push('frontend_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script src="https://cdn.datatables.net/2.0.3/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/2.0.3/js/dataTables.bootstrap5.js"></script>
<script>
    @if(Session::has('message'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("{{ session('message') }}");
    @endif

    @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("{{ session('error') }}");
    @endif

    @if(Session::has('info'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("{{ session('info') }}");
    @endif

    @if(Session::has('warning'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("{{ session('warning') }}");
    @endif
</script>
<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            pagingType: 'first_last_numbers',
        });
    });
</script>
@endpush
