@extends('frontend.master')
@section('title')
    Recruiter Login
@endsection
@push('favicon')
    @php $logo = \App\Models\Logo::latest()->first() @endphp
    <link rel="icon" type="image/png" href="{{asset($logo->logo_image)}}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<style>
    .password-wrapper {
        position: relative;
    }

    .toggle-password {
        position: absolute;
        top: 70%;
        right: 20px;
        transform: translateY(-50%);
        cursor: pointer;
    }

    .toggle-password i {
        color: #2490EB; /* Adjust color as needed */
    }

    .toggle-password.active i {
        color: #007bff; /* Color when active, adjust as needed */
    }

</style>
@endpush
@section('content')

<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Recruiter Login</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home </a></li>
                    <li>Recruiter Login</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Recruiter Login Form Start -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 offset-lg-3 col-md-8 offset-md-2 col-12">
                    <div class="login-form-wrap">
                        <div class="login-header">
                            <h3>Recruiter Login Form</h3>
                            @if(session('error'))
                            <p class="text-danger">{{session('error')}}</p>
                            @endif
                        </div>
                        <form action="{{ route('login.store') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="form-group">
                                        <label for="email" class="form-label">User Email Address <span class="text-danger">*</span></label>
                                        <input type="email" name="email" class="form-control py-3 rounded-0 @error('email') is-invalid @enderror"
                                        value="{{ old('email') }}">
                                        @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <div class="form-group password-wrapper">
                                        <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                                        <input type="Password" name="password" id="password" class="form-control py-3 rounded-0 @error('email') is-invalid @enderror">
                                        <span class="toggle-password">
                                            <i class="fa-solid fa-eye" id="togglePassword"></i>
                                        </span>
                                        @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <div class="form-group">
                                        <button type="submit" class="btn style1 rounded-0 w-100">SIGN IN</button>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <a href="{{ route('register.page') }}">Or Creat an Account</a>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <!-- Recruiter Login Form End -->


</div>
<!-- Content wrapper end -->
@endsection
@push('frontend_script')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var passwordField = document.getElementById('password');
        var togglePassword = document.getElementById('togglePassword');

        togglePassword.addEventListener('click', function() {
            var type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);
            if (type === 'text') {
                togglePassword.classList.remove('fa-eye');
                togglePassword.classList.add('fa-eye-slash');
            } else {
                togglePassword.classList.remove('fa-eye-slash');
                togglePassword.classList.add('fa-eye');
            }
        });
    });
</script>
@endpush