@extends('frontend.master')
@section('title')
    Job Application
@endsection
@push('favicon')
    @php $logo = \App\Models\Logo::latest()->first() @endphp
    <link rel="icon" type="image/png" href="{{asset($logo->logo_image)}}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<link rel="stylesheet" type="text/css"
      href="{{asset('/')}}admin/assets/node_modules/datatables.net-bs4/css/dataTables.bootstrap4.css">
<link rel="stylesheet" type="text/css"
      href="{{asset('/')}}admin/assets/node_modules/datatables.net-bs4/css/responsive.dataTables.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .text_custom {
        color: #2490EB !important;
    }
    .btn_custom {
        background-color: transparent;
        border: none;
    }
</style>
@endpush
@section('content')
<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($recruiter->banner_image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Job Application Information</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home </a></li>
                    <li>Job Application Information</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <div class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center mb-5">
                    <h1>My Job Circular</h1>
                </div>
                <div class="col-lg-12 login-form-wrap">
                    <div class="table-responsive">
                        <table id="dataTable2" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th class="text-center">Logo</th>
                                    <th>Job Title</th>
                                    <th>Company Name</th>
                                    <th>Department</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($rejobcirculars as $key => $rejobcircular)
    
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td class="text-center">
                                        <img src="{{ asset('jobcircular') }}/{{ $rejobcircular->company_logo??null }}"
                                        class="rounded-circle" alt="" style="width:30px; height:30px;">
                                    </td>
                                    <td>{{ $rejobcircular->job_title??null }}</td>
                                    <td>{{ $rejobcircular->company_nam??null }}</td>
                                    <td>{{ $rejobcircular->department->company_department_name??null }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div>
                                                <a href="{{ route('myjob.view', ['id' => $rejobcircular->id]) }}"
                                                    class="action-btn bs-tooltip me-2" data-toggle="tooltip"
                                                    data-placement="top" title="" data-bs-original-title="View">
                                                    <i class="fa-solid fa-eye text-success"></i>
                                                </a>
                                            </div>
                                            <div>
                                                <a href="{{ route('myjob.edit', ['id' => $rejobcircular->id]) }}"
                                                    class="action-btn bs-tooltip me-1" data-toggle="tooltip"
                                                    data-placement="top" title="" data-bs-original-title="Edit">
                                                    <i class="fa-regular fa-pen-to-square text-info"></i>
                                                </a>
                                            </div>
                                            <div>
                                                <form action="{{ route('myjob.delete', ['id' => $rejobcircular->id]) }}"
                                                    method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-danger btn_custom show_confirm" data-toggle="tooltip"
                                                    data-placement="top" data-bs-original-title="Delete">
                                                        <i class="fa-solid fa-trash-can fa-fw"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Job List Start -->
    <div class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center mb-5">
                    <h1>The Applicant</h1>
                </div>
                <div class="col-lg-12 login-form-wrap">
                    <div class="table-responsive">
                    <table id="dataTable" class="table display table-striped border no-wrap">
                        <thead>
                        <tr>
                            <th>List</th>
                            <th>Last Updated</th>
                            <th>Department</th>
                            <th>Profile</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($reapplies as $key => $apply)
                        <tr>
                            <td>{{ ++$key }}</td>
                            <td>{{ $apply->updated_at->format('d-M-Y') }}</td>
                            <td>{{ $apply->reJobCircular->department->company_department_name }}</td>
                            <td>
                                @if ($apply->user->profile->profileImage??null)
                                <div class="avatar-container">
                                    <img alt="avatar"
                                        src="{{ asset($apply->user->profile->profileImage->profile_image??null) }}"
                                        class="rounded-circle" style="width:30px; height: 30px">
                                </div>
                                @else
                                <div class="avatar-container">
                                    <img alt="avatar" src="{{ asset('profile/default_profile.png') }}"
                                    class="rounded-circle" style="width:30px; height: 30px">
                                </div>
                                @endif
                            </td>
                            <td>{{ $apply->user->name }}</td>
                            <td>{{ $apply->user->email }}</td>
                            <td>
                                @if ($apply->is_active == 1)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-warning">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div>
                                        <a href="{{ route('applyjob.view', ['id' => $apply->id]) }}"
                                            class="action-btn bs-tooltip me-2" data-toggle="tooltip"
                                            data-placement="top" title="" data-bs-original-title="View">
                                            <i class="fa-solid fa-eye text-success"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <a href="{{ route('applyjob.edit', ['id' => $apply->id]) }}"
                                            class="action-btn bs-tooltip me-1" data-toggle="tooltip"
                                            data-placement="top" title="" data-bs-original-title="Edit">
                                            <i class="fa-regular fa-pen-to-square text-info"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <form action="{{ route('applyjob.delete', ['id' => $apply->id]) }}"
                                            method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-danger btn_custom show_confirm" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Delete">
                                                <i class="fa-solid fa-trash-can fa-fw"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Job List End -->

</div>
<!-- Content wrapper end -->
@endsection

@push('frontend_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.6.11/dist/sweetalert2.all.min.js"></script>
<!-- This is data table -->
<script src="{{asset('/')}}admin/assets/node_modules/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="{{asset('/')}}admin/assets/node_modules/datatables.net-bs4/js/dataTables.responsive.min.js"></script>
<script>
    $(function () {
        // Initialize DataTable for #myTable (if exists)
        $('#myTable').DataTable();

        // Initialize DataTable for #example with options
        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function (settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function (group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });

        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function () {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });

        // Initialize DataTable for #dataTable with responsive option
        $('#dataTable').DataTable({
            responsive: true
        });
        $('#dataTable2').DataTable({
            responsive: true
        });

        // Initialize DataTable for #example23 with buttons
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });

        // Add button styling
        $('.buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel').addClass('btn btn-primary me-1');
    });
</script>
<script>
    @if(Session::has('message'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("{{ session('message') }}");
    @endif

    @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("{{ session('error') }}");
    @endif

    @if(Session::has('info'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("{{ session('info') }}");
    @endif

    @if(Session::has('warning'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("{{ session('warning') }}");
    @endif
</script>
<script>
    $('.show_confirm').click(function(event){
        let form = $(this).closest('form');

        event.preventDefault();
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
                Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
                )
            }
            })
        })
</script>
@endpush
