@extends('frontend.master')
@section('title')
    Job Application Details
@endsection
@push('favicon')
    @php $logo = \App\Models\Logo::latest()->first() @endphp
    <link rel="icon" type="image/png" href="{{asset($logo->logo_image)}}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .text_custom {
        color: #2490EB !important;
    }
    .btn_custom {
        background-color: transparent;
        border: none;
    }
</style>
@endpush
@section('content')
<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Job Applicant's Details</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home </a></li>
                    <li>Job Applicant's Details</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Job List Start -->
    <div class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 login-form-wrap">
                    <div class="d-flex justify-content-between mb-5 align-items-center">
                        <h1>Job Circular Update</h1>
                        <a href="{{ route('applyjob.index') }}" class="btn style1 rounded-0">Go Back</a>
                    </div>
                    <form class="form-horizontal" action="{{ route('myjob.update', ['id' => $rejobcircular->id]) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="department_id" class="form-label mb-2">Select Department</label>
                                    <select id="defaultSelect" name="department_id"
                                        class="form-select py-3 rounded-0
                                    @error('department_id')
                                        is-invalid
                                    @enderror">
                                        <option selected>Choose a Department</option>
                                        @forelse ($departments as $department)
                                            <option value="{{ $department->id }}" @if ($department->id == $rejobcircular->department_id)
                                                selected
                                            @endif>{{ $department->company_department_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('department_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="company_id" class="form-label mb-2">Select Comapny</label>
                                    <select id="defaultSelect" name="company_id"
                                        class="form-select py-3 rounded-0
                                    @error('company_id')
                                        is-invalid
                                    @enderror">
                                        <option selected>Choose a Comapny</option>
                                        @forelse ($companies as $company)
                                            <option value="{{ $company->id }}" @if ($company->id == $rejobcircular->company_id)
                                                selected
                                            @endif>{{ $company->company_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('company_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="producttype_id" class="form-label mb-2">Select Product Type</label>
                                    <select id="defaultSelect" name="producttype_id"
                                        class="form-select py-3 rounded-0
                                    @error('producttype_id')
                                        is-invalid
                                    @enderror">
                                        <option selected>Choose a Product</option>
                                        @forelse ($producttypes as $producttype)
                                            <option value="{{ $producttype->id }}" @if ($producttype->id == $rejobcircular->producttype_id)
                                                selected
                                            @endif>{{ $producttype->product_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('producttype_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="job_title" class="form-label mb-2">Job Title</label>
                                    <input type="text" class="form-control py-3 rounded-0 @error('job_title')
                                    is-invalid
                                    @enderror" rows="5" name="job_title" value="{{ $rejobcircular->job_title }}" id="job_title">
                                    @error('job_title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="company_nam" class="form-label mb-2">Company Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control py-3 rounded-0 @error('company_nam')
                                    is-invalid
                                    @enderror" rows="5" name="company_nam" value="{{ $rejobcircular->company_nam }}" id="company_nam">
                                    @error('company_nam')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="vacancy" class="form-label mb-2">Vacancy</label>
                                    <input type="number" class="form-control py-3 rounded-0 @error('vacancy')
                                    is-invalid
                                    @enderror" rows="5" name="vacancy" value="{{ $rejobcircular->vacancy }}" id="vacancy">
                                    @error('vacancy')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="job_banner" class="form-label mb-2">Job Thumbnail</label>
                                    <input type="file" class="form-control py-3 px-4 rounded-0 @error('job_banner')
                                    is-invalid
                                    @enderror" rows="5" name="job_banner" value="{{ old('job_banner') }}" id="job_banner">
                                    @error('job_banner')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div>
                                    <img src="{{ asset('jobcircular') }}/{{ $rejobcircular->job_banner }}"
                                    class="" alt="" style="height:100px;">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="responsibilities" class="form-label mb-2">Responsibilities</label>
                                    <textarea id="" class="form-control py-3 rounded-0 @error('responsibilities')
                                    is-invalid
                                    @enderror" col="10" row="5" name="responsibilities" >{!! $rejobcircular->responsibilities !!}</textarea>
                                </div>
                                @error('responsibilities')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="experience" class="form-label mb-2">Experience</label>
                                    <textarea id="" class="form-control py-3 rounded-0 @error('experience')
                                    is-invalid
                                    @enderror" col="10" row="5" name="experience" >{!! $rejobcircular->experience !!}</textarea>
                                </div>
                                @error('experience')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="location" class="form-label mb-2">Location</label>
                                    <textarea id="" class="form-control py-3 rounded-0 @error('location')
                                    is-invalid
                                    @enderror" col="10" row="5" name="location" >{!! $rejobcircular->location !!}</textarea>
                                </div>
                                @error('location')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="qualification" class="form-label mb-2">Qualification</label>
                                    <input type="text" class="form-control py-3 rounded-0 @error('qualification')
                                    is-invalid
                                    @enderror" rows="5" name="qualification" value="{{ $rejobcircular->qualification }}" id="qualification">
                                    @error('qualification')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="salary_range" class="form-label mb-2">Salary Range</label>
                                    <input type="text" class="form-control py-3 rounded-0 @error('salary_range')
                                    is-invalid
                                    @enderror" rows="5" name="salary_range" value="{{ $rejobcircular->salary_range }}" id="salary_range">
                                    @error('salary_range')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="others_facilities" class="form-label mb-2">Others Facilities</label>
                                    <input type="text" class="form-control py-3 rounded-0 @error('others_facilities')
                                    is-invalid
                                    @enderror" rows="5" name="others_facilities" value="{{ $rejobcircular->others_facilities }}" id="others_facilities">
                                    @error('others_facilities')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12 mb-3">
                                <div class="form-group mb-3">
                                    <label for="company_logo" class="form-label mb-2">Company Logo</label>
                                    <input type="file" class="form-control py-3 px-4 rounded-0 @error('company_logo')
                                    is-invalid
                                    @enderror" rows="5" name="company_logo" value="" id="company_logo">
                                    @error('company_logo')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div>
                                    <img src="{{ asset('jobcircular') }}/{{ $rejobcircular->company_logo }}"
                                    class="" alt="" style="height:100px;">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="deadline_till" class="form-label mb-2">Dead Line</label>
                                    <input type="date" class="form-control py-3 px-4 rounded-0 @error('deadline_till')
                                    is-invalid
                                    @enderror" rows="5" name="deadline_till" value="{{ $rejobcircular->deadline_till }}">
                                    @error('deadline_till')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="table-responsive">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Job List End -->

</div>
<!-- Content wrapper end -->
@endsection

@push('frontend_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    @if(Session::has('message'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("{{ session('message') }}");
    @endif

    @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("{{ session('error') }}");
    @endif

    @if(Session::has('info'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("{{ session('info') }}");
    @endif

    @if(Session::has('warning'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("{{ session('warning') }}");
    @endif
</script>
@endpush
