@extends('frontend.master')
@section('title')
    Orientation Member
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .social_link a {
        font-size: 24px;
        color: #2490EB;
    }
</style>
@endpush
@section('content')

    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image)}});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Orientation Member</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{route('front.page')}}">Home </a></li>
                        <li>Orientation Member</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Blog  Section Start -->
        <div class="blog-wrap ptb-100">
            <div class="container">
                <div class="row justify-content-center">
                    @foreach($users as $user)
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="blog-card style2 p-4">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h3><a href="blog-details-right-sidebar.html">{{$user->name}} </a></h3>
                                @if ($user->adminProfileImage)
                                    <div class="avatar-container">
                                        <img alt="avatar"
                                            src="{{ asset($user->adminProfileImage->admin_profile_image) }}"
                                            class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                @elseif ($user->profile->profileImage??null)
                                    <div class="avatar-container">
                                        <img alt="avatar"
                                            src="{{ asset($user->profile->profileImage->profile_image??null) }}"
                                            class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                @else
                                    <div class="avatar-container">
                                        <img alt="avatar" src="{{ asset('profile/default_profile.png') }}"
                                        class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                @endif
                                
                            </div>
                            <div>
                                <table class="table table-striped table-bordered table-hover">
                                    <tbody>
                                        <tr>
                                            <th>Name</th>
                                            <td>{{ $user->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td>{{ $user->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>University</th>
                                            <td>{{ $user->career->university ?? 'N/A'}}</td>
                                        </tr>
                                        <tr>
                                            <th>Address</th>
                                            <td>{{ $user->profile->address ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Blood Group</th>
                                            <td>{{ $user->profile->blood_group ?? 'N/A' }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="social_link d-flex justify-content-evenly">
                                <a href="{!! $user->profile->facebook??null !!}"><i class="fa-brands fa-facebook-f"></i></a>
                                <a href="{!! $user->profile->twitter??null !!}"><i class="fa-brands fa-twitter"></i></a>
                                <a href="{!! $user->profile->linkedIn??null !!}"><i class="fa-brands fa-linkedin-in"></i></a>
                                <a href="{!! $user->profile->instagram??null !!}"><i class="fa-brands fa-instagram"></i></a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                    {{$users->links()}}
                </div>
            </div>
        </div>
        <!-- Blog Section End -->

    </div>
    <!-- Content wrapper end -->
@endsection
@push('frontend_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    @if(Session::has('message'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("{{ session('message') }}");
    @endif

    @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("{{ session('error') }}");
    @endif

    @if(Session::has('info'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("{{ session('info') }}");
    @endif

    @if(Session::has('warning'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("{{ session('warning') }}");
    @endif
</script>
@endpush