@extends('frontend.master')
@section('title')
    Notice Details
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@section('content')

    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image)}});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Notice Details</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{route('front.page')}}">Home </a></li>
                        <li>Notice Details</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Notice Section Start -->
        <section class="my-5">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12 text-center">
                        <div class="section-title style1 text-center mb-40">
                            <h2 style="color: #2490EB !important;">{{ $notice->title??null }}</h2>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <img src="{{ asset('notice') }}/{{ $notice->poster??null }}" class="img-fluid w-100">
                    </div>
                    <div class="col-lg-6">
                        <p>{!! $notice->description??null !!}</p>
                        <a href="" class="btn style1 rounded-0">Register</a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Notice Section End -->

        <!-- Previous Notices Start -->
        <section class="team-wrap ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-12 text-center">
                        <div class="section-title style1 text-center mb-40">
                            <h2>View Previous Notices</h2>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                        <div class="testimonial-slider-two owl-carousel text-center">
                            @forelse ($notices as $notice)
                            <div class="team-card style1" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                                <div class="">
                                    <a href="{{ route('notice.details', ['id' => $notice->id]) }}">
                                        <img data-aos="zoom-in-up" data-aos-duration="1200" data-aos-delay="200"  src="{{ asset('notice') }}/{{ $notice->poster??null }}" class="img-fluid w-100">
                                        <h2 data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200" style="color: #2490EB !important;">{{ $notice->title??null }}</h2>
                                    </a>
                                </div>
                            </div>
                            @empty
                            No Previous Notice Found!
                            @endforelse
                        </div>
                    {{-- @endif --}}
                </div>
            </div>
        </section>
        <!-- Previous Notices End -->

    </div>
    <!-- Content wrapper end -->
@endsection
