<section class="about-wrap style2 my-5">
    <div class="container">
        <div class="row gx-5">
            <div class="col-lg-10 text-center contact-form">
                @if ($notice)
                    <div class="">
                        <a href="{{ route('notice.details', ['id' => $notice->id]) }}">
                            <img data-aos="zoom-in-up" data-aos-duration="1200" data-aos-delay="200" src="{{ asset('notice') }}/{{ $notice->poster ?? null }}" class="img-fluid w-100">
                            <h2 data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200" style="color: #2490EB !important;">{{ $notice->title ?? null }}</h2>
                        </a>
                    </div>
                @else
                    <h4 class="text-danger">Couldn't find any notice!</h4>
                @endif
            </div>

            @php
                use Illuminate\Support\Str;
            @endphp

            <div class="col-lg-2 d-none d-lg-block">
                @forelse ($notices as $notice)
                    <div class="mb-4 p-3" style="box-shadow: 0 0 15px rgba(0, 0, 0, 0.09);">
                        <a href="{{ route('notice.details', ['id' => $notice->id]) }}">
                            <img data-aos="zoom-in-up" data-aos-duration="1200" data-aos-delay="200" src="{{ asset('notice') }}/{{ $notice->poster ?? null }}" class="img-fluid w-100">
                        </a>
                        <p class="mb-0">{{ Str::limit($notice->title, $limit = 15, $end = '...') }}</p>
                    </div>
                @empty
                    No Previous Notice Found!
                @endforelse
            </div>
        </div>
    </div>
</section>
