@extends('frontend.master')

@section('title', 'Member Forum')
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@push('frontend_style')
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .social_link a {
        font-size: 24px;
        color: #2490EB;
    }
    .card-img-top{
        height:300px;
    }
    .card-no-border .card {
        border-color: #d7dfe3;
        border-radius: 4px;
        margin-bottom: 30px;
        -webkit-box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.05);
        box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.05)
    }
    .card-body {
        -ms-flex: 1 1 auto;
        flex: 1 1 auto;
        padding: 1.25rem
    }
    .pro-img {
        margin-top: -80px;
        margin-bottom: 20px
    }
    .little-profile .pro-img img {
        width: 128px;
        height: 128px;
        -webkit-box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
        border-radius: 100%
    }
</style>
@endpush

@section('content')
<div class="content-wrapper">
    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{ asset($banner->image) }});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Member Forum</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{ route('front.page') }}">Home</a></li>
                    <li>Member Forum</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Recipient Details and Message Form Start -->
    <div class="recipient-details-wrap ptb-100">
        <div class="container">
            <div class="row py-5">
                <div class="col-md-4">
                    <div class="card blog-card style2">
                        <img class="card-img-top" src="{{ asset($banner->image) }}" alt="Card image cap">
                        <div class="card-body little-profile text-center">
                            <div class="pro-img">
                                <img alt="avatar" src="{{ asset($recipient->profile->profileImage->profile_image ?? 'profile/default_profile.png') }}">
                            </div>
                            <h3 class="m-b-0">{{ $recipient->name }}</h3>
                            @if ($recipient->career)
                            <p><strong>Designation:</strong> {{ $recipient->career->designation }}</p>
                            <p><strong>Company Name:</strong> {{ $recipient->career->company_name }}</p>
                            @else
                            <p class="text-danger"><strong>Hey! Update your CV</strong></p>
                            @endif
                            <hr>
                            <div class="social_link d-flex justify-content-evenly mt-4">
                                <a href="{{ $recipient->profile->facebook ?? '#' }}"><i class="fa-brands fa-facebook-f"></i></a>
                                <a href="{{ $recipient->profile->twitter ?? '#' }}"><i class="fa-brands fa-twitter"></i></a>
                                <a href="{{ $recipient->profile->linkedin ?? '#' }}"><i class="fa-brands fa-linkedin-in"></i></a>
                                <a href="{{ $recipient->profile->instagram ?? '#' }}"><i class="fa-brands fa-instagram"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-4 blog-card style2">
                        <div class="card-body">
                            <h4>Send a Message</h4>
                            <form action="{{ route('message.store') }}" method="POST">
                                @csrf
                                <input type="hidden" name="recipient_id" value="{{ $recipient->id }}">
                                <div class="form-group">
                                    <label for="message_description">Message</label>
                                    <textarea name="message_description" id="message_description" class="form-control" rows="4" required></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary mt-3">Send</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">

                </div>
            </div>
        </div>
    </div>
    <!-- Recipient Details and Message Form End -->
</div>
@endsection

@push('frontend_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    @if (Session::has('message'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
        }
        toastr.success("{{ session('message') }}");
    @endif

    @if (Session::has('error'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.error("{{ session('error') }}");
    @endif

    @if (Session::has('info'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.info("{{ session('info') }}");
    @endif

    @if (Session::has('warning'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.warning("{{ session('warning') }}");
    @endif
</script>
@endpush
