@extends('frontend.master')
@section('title')
    Presidium Member
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@push('frontend_style')
    <!--Toaster Popup message CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        .profile_setting a {
            background-color: transparent !important;
        }

        .profile_setting .active {
            background-color: #2490EB !important;
        }

        .profile_setting .active:hover {
            color: #fff !important;
        }

        .social_link a {
            font-size: 24px;
            color: #2490EB;
        }

        .card-img-top{
            height:120px;
            background: #3162a3;

        }

        .card-no-border .card {
            border-color: #d7dfe3;
            border-radius: 4px;
            margin-bottom: 30px;
            -webkit-box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.05);
            box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.05)
        }

        .card-body {
            -ms-flex: 1 1 auto;
            flex: 1 1 auto;
            padding: 1.25rem
        }

        .pro-img {
            margin-top: -80px;
            margin-bottom: 20px
        }

        .little-profile .pro-img img {
            width: 128px;
            height: 128px;
            -webkit-box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
            border-radius: 100%
        }

        /* Custom Pagiantion Start */
        nav {
            display: flex;
            justify-content: center;
            padding-top: 20px;
        }
        .pagination {
            display: flex;
        }
        .page-item {
            list-style: none;
        }
        .page-link {
            width: 50px;
            height: 50px;
            line-height: 30px;
            text-align: center;
            display: inline-block;
            padding: 10px;
            background-color: #007bff;
            color: #fff;
            border: 1px solid #fff;
            text-decoration: none;
            transition: background-color 0.3s;
        }
        .page-link:hover {
            background-color: #0056b3;
            color: #fff;
        }

        .page-link:focus {
            box-shadow: none;
            outline: none;
        }

        .page-item.active .page-link {
            background-color: #0056b3;
            border: 1px solid #fff;
        }
        /* Custom Pagiantion End */
    </style>
@endpush
@section('content')
    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url({{ asset($banner->image) }});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Presidium Member</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{ route('front.page') }}">Home </a></li>
                        <li>Presidium Member</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Blog  Section Start -->
        <div class="blog-wrap ptb-100">
            <div class="container">
                <div class="row justify-content-center py-5">
                    @foreach ($users as $user)
                        <div class="col-xl-4 col-lg-6 col-md-6">
                            <div class="card blog-card style2" style="min-height: 580px;"> <span class="card-img-top"></span>
                                {{-- <img class="card-img-top" src="{{ asset($banner->image) }}" alt="Card image cap"> --}}
                                <div class="card-body little-profile text-center">
                                    @if ($user->profile->profileImage ?? null)
                                        <div class="pro-img">
                                            <img alt="avatar"
                                                src="{{ asset($user->profile->profileImage->profile_image ?? null) }}">
                                        </div>
                                    @else
                                        <div class="pro-img">
                                            <img alt="avatar" src="{{ asset('profile/default_profile.png') }}">
                                        </div>
                                    @endif
                                    <h3 class="m-b-0">{{$user->name??null}}</h3>
                                    <hr>
                                    @if ($user->career)
                                    <p><strong>{{ $user->career->designation??null }}</strong></p>
                                    <p><strong>{{ $user->career->company_name??null }}</strong></p>
                                    @else
                                        <p class="text-danger"><strong>Hey! Update your CV</strong></p>
                                    @endif
                                    <hr>
                                    <div class="social_link d-flex justify-content-evenly mt-4">
                                        <a target="_blank" href="{!! $user->profile->facebook??null !!}"><i class="fa-brands fa-facebook-f"></i></a>
                                        <a target="_blank" href="{!! $user->profile->twitter??null !!}"><i class="fa-brands fa-twitter"></i></a>
                                        <a target="_blank" href="{!! $user->profile->linkedIn??null !!}"><i class="fa-brands fa-linkedin-in"></i></a>
                                        <a target="_blank" href="{!! $user->profile->instagram??null !!}"><i class="fa-brands fa-instagram"></i></a>
                                    </div>
                                </div>
                                <div class="card-footer px-4 d-flex justify-content-between align-items-center" style="background-color: #3162a3; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px;">
                                        <h5 class="text-white">{{ $user->memberRole->member_role_name??null }}</h5>
                                    <!-- Message Envelope Icon/Button -->
                                    <a class="text-white" target="_blank" href="{{ url('chatify') }}" style="font-size: 24px;">
                                        <i class="fa-solid fa-envelope"></i>
                                    </a>
                                </div>

                                <!-- Message Modal -->
                                {{-- <div class="modal fade" id="messageModal{{ $user->id }}" tabindex="-1" aria-labelledby="messageModalLabel{{ $user->id }}" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title d-flex" id="messageModalLabel{{ $user->id }}">@if ($user->profile->profileImage ?? null)
                                                    <div  class="me-4" style="width: 40px; height: 40px; border-radius: 50%;">
                                                        <img alt="avatar" class="rounded-circle"
                                                            src="{{ asset($user->profile->profileImage->profile_image ?? null) }}">
                                                    </div>
                                                @else
                                                    <div  class="me-4" style="width: 40px; height: 40px; border-radius: 50%;">
                                                        <img alt="avatar" class="rounded-circle" src="{{ asset('profile/default_profile.png') }}">
                                                    </div>
                                                @endif {{ $user->name }}</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('message.store') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="recipient_id" value="{{ $user->id }}">
                                                    <div class="form-group">
                                                        <label for="message_description">Message</label>
                                                        <textarea name="message_description" id="message_description" class="form-control" rows="4" required></textarea>
                                                    </div>
                                                    <button type="submit" class="btn style1 rounded-0 mt-3">Send</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}

                            </div>
                        </div>
                    @endforeach
                    {{ $users->links() }}
                </div>
            </div>
        </div>
        <!-- Blog Section End -->
    </div>
    <!-- Content wrapper end -->
@endsection
@push('frontend_script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
    <script>
        @if (Session::has('message'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
            }
            toastr.success("{{ session('message') }}");
        @endif

        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("{{ session('error') }}");
        @endif

        @if (Session::has('info'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.info("{{ session('info') }}");
        @endif

        @if (Session::has('warning'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.warning("{{ session('warning') }}");
        @endif
    </script>
    <script>
        function openMessageModal(userId) {
            // Get the modal element using its ID
            var modal = document.getElementById('messageModal' + userId);

            // Open the modal
            var modalInstance = new bootstrap.Modal(modal);
            modalInstance.show();
        }
    </script>
@endpush
