@extends('frontend.master')
@section('title')
    Job Details
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    @media (min-width: 0) and (max-width: 767.98px) {
        .btn_custom {
            width: 100%;
            margin-bottom: 10px;
        }
    }
    @media (min-width: 768px) and (max-width: 991.98px) {
        .btn_custom {
            width: 100%;
            margin-bottom: 10px;
        }
    }
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .text_custom {
        color: #2490EB !important;
    }
</style>
@endpush
@section('content')
<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($recruiter->banner_image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Job Circular Information</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home </a></li>
                    <li>Job Circular Information</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <div class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 login-form-wrap mb-3">
                    <div class="d-lg-flex justify-content-lg-between text-center text-lg-start align-items-center pb-3">
                        <h2>Job Details</h2>
                        <div>
                            <a href="{{ route('jobcircular.list') }}" class="btn btn-info btn_custom"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>
                            <a href="#apply" class="btn style1 rounded-0 btn_custom" data-toggle="tooltip" data-placement="top" data-bs-original-title="View">
                            Apply Now
                        </a></div>
                    </div>
                    <table class="table table-striped table-bordered table-hover">
                        <tbody>
                            <tr>
                                <th><h4>Job Title</h4></th>
                                <td><h4>{{ $jobcircular->job_title }}</h4></td>
                            </tr>
                            <tr>
                                <th>Company Logo</th>
                                <td>
                                    <img src="{{ asset('jobcircular') }}/{{ $jobcircular->company_logo }}"
                                    class="" alt="" style="width:100px; height:100px;">
                                </td>
                            </tr>
                            <tr>
                                <th>Company Name</th>
                                <td>{{ $jobcircular->company_nam }}</td>
                            </tr>
                            <tr>
                                <th>Company Type</th>
                                <td>{{ $jobcircular->company->company_name }}</td>
                            </tr>
                            <tr>
                                <th>Department</th>
                                <td>{{ $jobcircular->department->company_department_name }}</td>
                            </tr>
                            <tr>
                                <th>Product Type</th>
                                <td>{{ $jobcircular->productType->product_name }}</td>
                            </tr>
                            <tr>
                                <th>Vacancy</th>
                                <td>{{ $jobcircular->vacancy }}</td>
                            </tr>
                            <tr>
                                <th>Responsibilities</th>
                                <td>{!! $jobcircular->responsibilities !!}</td>
                            </tr>
                            <tr>
                                <th>Experience</th>
                                <td>{!! $jobcircular->experience !!}</td>
                            </tr>
                            <tr>
                                <th>Qualification</th>
                                <td>{{ $jobcircular->qualification }}</td>
                            </tr>
                            <tr>
                                <th>Others Facilities</th>
                                <td>{{ $jobcircular->others_facilities }}</td>
                            </tr>
                            <tr>
                                <th>Salary Range</th>
                                <td>{{ $jobcircular->salary_range }}</td>
                            </tr>
                            <tr>
                                <th>Location</th>
                                <td>{!! $jobcircular->location !!}</td>
                            </tr>
                            <tr>
                                <th>Dead Line</th>
                                @if($jobcircular->deadline_till >= now())
                                    <td><span class="badge text-bg-success">{{ $jobcircular->deadline_till }}</span></td>
                                @else
                                    <td><span class="badge text-bg-danger">Expired</span></td>
                                @endif
                            </tr>
                            <tr>
                                <th>Created Date</th>
                                <td>{{ $jobcircular->created_at->format('d-M-Y') }}</td>
                            </tr>
                            <tr>
                                <th>Last Updated</th>
                                <td>{{ $jobcircular->updated_at->format('d-M-Y') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="col-lg-12 login-form-wrap" id="apply">
                    <div class="row">
                        <h2>Apply Now</h2>
                    </div>
                    <form action="{{ route('applyjob.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <input type="hidden" value="{{ $jobcircular->id }}" name="job_title">
                            <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <label for="subject" class="form-label mb-2">Subject <span class="text-danger">*</span></label>
                                    <input type="text" name="subject" class="form-control py-3 rounded-0 @error('subject') is-invalid @enderror"
                                    value="{{ old('subject') }}">
                                    @error('subject')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="application_details" class="form-label mb-2">Mail cover letter <span class="text-danger">*</span></label>
                                    <textarea id="tinymce" class="rounded-0 form-control @error('application_details')
                                    is-invalid
                                    @enderror" col="10" rows="5" name="application_details" >{{ old('application_details') }}</textarea>
                                </div>
                                @error('application_details')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <button type="submit" class="btn style1 rounded-0">Apply</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


</div>
<!-- Content wrapper end -->
@endsection

@push('frontend_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    @if(Session::has('message'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("{{ session('message') }}");
    @endif

    @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("{{ session('error') }}");
    @endif

    @if(Session::has('info'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("{{ session('info') }}");
    @endif

    @if(Session::has('warning'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("{{ session('warning') }}");
    @endif
</script>
@endpush
