@extends('frontend.master')
@section('title')
    Inbox
@endsection

@push('favicon')
    @php $logo = \App\Models\Logo::latest()->first() @endphp
    <link rel="icon" type="image/png" href="{{ asset($logo->logo_image) }}">
@endpush
@push('frontend_style')
    <style>
        /* Style the tab */
        .tab {
            float: left;
            border: 1px solid #ccc;
            background-color: transparent;
            width: 30%;
            height: 286px;
        }

        /* Style the buttons inside the tab */
        .tab button {
            display: block;
            background-color: inherit;
            /* color: black; */
            padding: 22px 16px;
            width: 100%;
            border: none;
            outline: none;
            text-align: left;
            cursor: pointer;
            transition: 0.3s;
            font-size: 17px;
            border-bottom: 1px solid #ccc;
        }

        /* Change background color of buttons on hover */
        .tab button:hover {
            background-color: transparent;
        }

        /* Create an active/current "tab button" class */
        .tab button.active {
            background-color: #2490EB;
            color: #fff;
        }

        /* Style the tab content */
        .tabcontent {
            position: relative;
            float: left;
            padding: 0px 12px;
            border: 1px solid #ccc;
            width: 70%;
            /* border-left: none; */
            height: 500px;
            overflow: hidden;
        }

        .custom_form {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 10px;
            background-color: #f9f9f9;
            border-top: 1px solid #ccc;
        }
        .overflow-scroll {
            overflow-y: auto; /* Vertical scrolling */
            height: 500px; /* Adjust the max-height as needed */
        }
    </style>
@endpush
@section('content')
    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url({{ asset($banner->image ?? null) }});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Inbox</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{ route('front.page') }}">Home </a></li>
                        <li>Inbox</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Contact Us section Start -->
        <section class="contact-us-wrap ptb-100">
            <div class="container">
                <div class="row gx-5 book-appointment-form">
                    <div class="col-md-12">
                        <div class="tab">
                            @foreach ($uniqueSenders as $sender)
                            <button class="tablinks" onclick="openCity(event, '{{ $sender->name }}')">
                                    @if ($sender->profile && $sender->profile->profileImage) 
                                        <img src="{{ asset($sender->profile->profileImage->profile_image??null) }}" class="profile_image" alt="Profile Image" style="width: 50px; height: 50px; border-radius: 50%;">
                                    @else
                                    <img src="{{ asset('profile/default_profile.png') }}" class="profile_image" style="width: 50px; height: 50px; border-radius: 50%;" alt="Default Profile Image">
                                    @endif
                                    {{ $sender->name }}
                                </button>
                            @endforeach
                        </div>
                        @foreach ($uniqueSenders as $key => $sender)
                            @if ($groupedMessages->has($sender->id))
                                <div id="{{ $sender->name }}" class="tabcontent {{ $key === 0 ? 'active' : '' }}" style="margin-bottom: 100vh">
                                    {{-- Loop through messages --}}
                                    <div class="overflow-scroll" style="padding-bottom: 80px; padding-top: 30px;">
                                        @foreach ($groupedMessages[$sender->id] as $message)
                                        <p class="{{ $message->sender_id == Auth::id() ? 'text-end' : 'text-start' }} mx-3">
                                            @if ($message->sender_id == Auth::id())
                                                    {{-- @if (Auth::user()->profile && Auth::user()->profile->profileImage) 
                                                    <img src="{{ asset(Auth::user()->profile->profileImage->profile_image??null) }}" class="profile_image" alt="Profile Image" style="width: 30px; height: 30px; border-radius: 50%;">
                                                @else
                                                <img src="{{ asset('profile/default_profile.png') }}" class="profile_image" style="width: 30px; height: 30px; border-radius: 50%;" alt="Default Profile Image">
                                                @endif --}}
                                            @else
                                                <strong>@if ($sender->profile && $sender->profile->profileImage) 
                                                    <img src="{{ asset($sender->profile->profileImage->profile_image??null) }}" class="profile_image" alt="Profile Image" style="width: 30px; height: 30px; border-radius: 50%;">
                                                @else
                                                <img src="{{ asset('profile/default_profile.png') }}" class="profile_image" style="width: 30px; height: 30px; border-radius: 50%;" alt="Default Profile Image">
                                                @endif</strong>
                                            @endif
                                            {!! $message->message_description !!}
                                        </p>
                                        @endforeach
                                    </div>
                                    <form action="{{ route('message.store') }}" method="POST" class="custom_form">
                                        @csrf
                                        <input type="hidden" name="recipient_id" value="{{ $sender->id }}">
                                        <div class="d-flex">
                                            <div class="form-group flex-grow-1 mb-0">
                                                <input type="text" class="form-control" name="message_description" placeholder="Type your message...">
                                            </div>
                                            <div><button type="submit" class="btn btn-primary">Send</button></div>
                                        </div>
                                    </form>
                                </div>
                            @endif
                        @endforeach

                    </div>
                </div>
            </div>
        </section>
        <!-- Contact Us section End -->

    </div>
    <!-- Content wrapper end -->
@endsection

@push('frontend_script')
    <script>
        function openCity(evt, cityName) {
            var i, tabcontent, tablinks;
            tabcontent = document.getElementsByClassName("tabcontent");
            for (i = 0; i < tabcontent.length; i++) {
                tabcontent[i].style.display = "none";
            }
            tablinks = document.getElementsByClassName("tablinks");
            for (i = 0; i < tablinks.length; i++) {
                tablinks[i].className = tablinks[i].className.replace(" active", "");
            }
            document.getElementById(cityName).style.display = "block";
            evt.currentTarget.className += " active";
        }

        // Get the element with id="defaultOpen" and click on it
        document.getElementById("defaultOpen").click();
    </script>
@endpush
