@extends('frontend.master')
@section('title')
    FAQ Details
@endsection
@section('content')

    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image)}});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>FAQ</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{route('front.page')}}">Home </a></li>
                        <li>FAQ</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Service Section Start -->
        <section class="service-wrap ptb-100">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="book-appointment-form mt-5">
                            <ul>
                                @forelse ($faqs as $faq)
                                <li>
                                    <div class="accordion" id="accordionExample">
                                        <div class="accordion-item">
                                            <button class="accordion-button bg-light px-3 py-2 my-3" type="button" data-bs-toggle="collapse" data-bs-target="#s{{ $faq->id }}" aria-expanded="true" aria-controls="s{{ $faq->id }}">
                                                <h6>{{ $faq->faq_question }}</h6>
                                            </button>
                                        <div id="s{{ $faq->id }}" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                            <div class="accordion-body">
                                                {{ $faq->faq_answer }}
                                            </div>
                                        </div>
                                        </div>
                                    </div>
                                </li>
                                @empty

                                @endforelse
                            </ul>
                        </div>

                    </div>

                </div>
            </div>
        </section>

        <!-- Service Section End -->

    </div>
    <!-- Content wrapper end -->
@endsection

