@extends('frontend.master')
@section('title')
    {{ Auth::user()->name }}
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@push('frontend_style')

<style>
    .text_custom {
        color: #2490EB !important;
    }
</style>
@endpush
@section('content')

    <!-- Content Wrapper Start -->
    <div class="content-wrapper" style="">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image)}});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>User Single Job Details</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{route('customer.dashboard')}}">Dashboard </a></li>
                        <li>User Single Job Details</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Customer Dashboard Start -->
        <div class="container py-5">
            <div class="book-appointment-form h-100 overflow-hidden">
                <div class="row">
                    <div class="d-flex justify-content-between mb-4 align-items-center">
                        <h1>Single Job Details (Recruiter)</h1>
                        <div><a href="{{ route('job.history') }}" class="btn style1 rounded-0">View History</a></div>
                    </div>
                    <div class="col-lg-12">
                        <table id="dataTable" class="table table-striped table-bordered table-hover" style="width:100%">
                            <tbody>
                                <tr><th colspan="2"><h3>{{ $apply->reJobCircular->job_title }}</h3></th></tr>
                                <tr>
                                    <th>Profile</th>
                                    <td>
                                        <img alt="avatar"
                                    src="{{ asset($apply->user->profile->profileImage->profile_image??null) }}"
                                    class="bg-white rounded-circle" style="width:120px; height:120px;">
                                    </td>
                                </tr>
                                <tr>
                                    <th>Name</th>
                                    <td>{{ $apply->user->name }}</td>
                                </tr>
                                <tr>
                                    <th>Company</th>
                                    <td>{{ $apply->reJobCircular->company->company_name }}</td>
                                </tr>
                                <tr>
                                    <th>Department</th>
                                    <td>{{ $apply->reJobCircular->department->company_department_name }}</td>
                                </tr>
                                <tr>
                                    <th>Product Type</th>
                                    <td>{{ $apply->reJobCircular->productType->product_name }}</td>
                                </tr>
                                <tr>
                                    <th>Vacancy</th>
                                    <td>{{ $apply->reJobCircular->vacancy }}</td>
                                </tr>
                                <tr>
                                    <th>Responsibilities</th>
                                    <td>{!! $apply->reJobCircular->responsibilities !!}</td>
                                </tr>
                                <tr>
                                    <th>Experience</th>
                                    <td>{!! $apply->reJobCircular->experience !!}</td>
                                </tr>
                                <tr>
                                    <th>Qualification</th>
                                    <td>{{ $apply->reJobCircular->qualification }}</td>
                                </tr>
                                <tr>
                                    <th>Others Facilities</th>
                                    <td>{{ $apply->reJobCircular->others_facilities }}</td>
                                </tr>
                                <tr>
                                    <th>Salary Range</th>
                                    <td>{{ $apply->reJobCircular->salary_range }}</td>
                                </tr>
                                <tr>
                                    <th>Location</th>
                                    <td>{!! $apply->reJobCircular->location !!}</td>
                                </tr>
                                <tr>
                                    <th>Dead Line</th>
                                    <td>{{ $apply->reJobCircular->deadline_till }}</td>
                                </tr>
                                <tr>
                                    <th>Created Date</th>
                                    <td>{{ $apply->reJobCircular->created_at->format('d-M-Y') }}</td>
                                </tr>
                                <tr>
                                    <th>Last Updated</th>
                                    <td>{{ $apply->reJobCircular->updated_at->format('d-M-Y') }}</td>
                                </tr>
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- Customer Dashboard End -->

    </div>
    <!-- Content wrapper end -->
@endsection

@push('frontend_script')

@endpush
