@extends('frontend.master')
@section('title')
    {{ Auth::user()->name }}
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@push('frontend_style')
{{-- <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.3/css/dataTables.bootstrap5.css"> --}}
<link rel="stylesheet" type="text/css"
      href="{{asset('/')}}admin/assets/node_modules/datatables.net-bs4/css/dataTables.bootstrap4.css">
<link rel="stylesheet" type="text/css"
      href="{{asset('/')}}admin/assets/node_modules/datatables.net-bs4/css/responsive.dataTables.min.css">
<style>
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .text_custom {
        color: #2490EB !important;
    }
    .btn_custom {
        background-color: transparent;
        border: none;
    }
</style>
@endpush
@section('content')

    <!-- Content Wrapper Start -->
    <div class="content-wrapper" style="">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image)}});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>User Job History</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{route('customer.dashboard')}}">Dashboard </a></li>
                        <li>User Job History</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Customer Dashboard Start -->
        <div class="container py-5">
            <div class="book-appointment-form h-100 overflow-hidden">
                <div class="row">
                    <div class="col-lg-12 text-center mb-5">
                        <h1>Job History(MBABD)</h1>
                    </div>
                    <div class="col-lg-12 login-form-wrap">
                        <div class="table-responsive">
                            <table id="dataTable" class="table table-striped" style="width:100%">
                                <thead>
                                <tr>
                                    <th>List</th>
                                    <th>Last Updated</th>
                                    <th>Department</th>
                                    <th>Profile</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($applies as $key => $apply)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $apply->updated_at->format('d-M-Y') }}</td>
                                        <td>{{ $apply->jobCircular->department->company_department_name }}</td>
                                        <td>
                                            @if ($apply->user->profile->profileImage??null)
                                            <div class="avatar-container">
                                                <img alt="avatar"
                                                    src="{{ asset($apply->user->profile->profileImage->profile_image??null) }}"
                                                    class="rounded-circle" style="width:30px; height: 30px">
                                            </div>
                                            @else
                                            <div class="avatar-container">
                                                <img alt="avatar" src="{{ asset('profile/default_profile.png') }}"
                                                class="rounded-circle" style="width:30px; height: 30px">
                                            </div>
                                            @endif
                                        </td>
                                        <td>{{ $apply->user->name }}</td>
                                        <td>{{ $apply->user->email }}</td>
                                        <td>
                                            @if ($apply->is_active == 1)
                                                <span class="badge bg-success">Active</span>
                                            @else
                                                <span class="badge bg-warning">Inactive</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div>
                                                    <a href="{{ route('applyjob.show', ['id' => $apply->id]) }}"
                                                        class="action-btn bs-tooltip me-2" data-toggle="tooltip"
                                                        data-placement="top" title="" data-bs-original-title="View">
                                                        <i class="fa-solid fa-eye text-success"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 text-center mb-5">
                        <h1>Job History(Recruiter)</h1>
                    </div>
                    <div class="col-lg-12 login-form-wrap">
                        <div class="table-responsive">
                            <table id="dataTable2" class="table table-striped" style="width:100%">
                                <thead>
                                <tr>
                                    <th>List</th>
                                    <th>Last Updated</th>
                                    <th>Department</th>
                                    <th>Profile</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($reapplies as $key => $apply)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $apply->updated_at->format('d-M-Y') }}</td>
                                        <td>{{ $apply->reJobCircular->department->company_department_name }}</td>
                                        <td>
                                            @if ($apply->user->profile->profileImage??null)
                                            <div class="avatar-container">
                                                <img alt="avatar"
                                                    src="{{ asset($apply->user->profile->profileImage->profile_image??null) }}"
                                                    class="rounded-circle" style="width:30px; height: 30px">
                                            </div>
                                            @else
                                            <div class="avatar-container">
                                                <img alt="avatar" src="{{ asset('profile/default_profile.png') }}"
                                                class="rounded-circle" style="width:30px; height: 30px">
                                            </div>
                                            @endif
                                        </td>
                                        <td>{{ $apply->user->name }}</td>
                                        <td>{{ $apply->user->email }}</td>
                                        <td>
                                            @if ($apply->is_active == 1)
                                                <span class="badge bg-success">Active</span>
                                            @else
                                                <span class="badge bg-warning">Inactive</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div>
                                                    <a href="{{ route('reapplyjob.show', ['id' => $apply->id]) }}"
                                                        class="action-btn bs-tooltip me-2" data-toggle="tooltip"
                                                        data-placement="top" title="" data-bs-original-title="View">
                                                        <i class="fa-solid fa-eye text-success"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- Customer Dashboard End -->

    </div>
    <!-- Content wrapper end -->
@endsection

@push('frontend_script')
{{-- <script src="https://cdn.datatables.net/2.0.3/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/2.0.3/js/dataTables.bootstrap5.js"></script> --}}
<!-- This is data table -->
<script src="{{asset('/')}}admin/assets/node_modules/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="{{asset('/')}}admin/assets/node_modules/datatables.net-bs4/js/dataTables.responsive.min.js"></script>
<script>
    $(function () {
        // Initialize DataTable for #myTable (if exists)
        $('#myTable').DataTable();

        // Initialize DataTable for #example with options
        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function (settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function (group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });

        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function () {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });

        // Initialize DataTable for #dataTable with responsive option
        $('#dataTable').DataTable({
            responsive: true
        });
        $('#dataTable2').DataTable({
            responsive: true
        });

        // Initialize DataTable for #example23 with buttons
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });

        // Add button styling
        $('.buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel').addClass('btn btn-primary me-1');
    });
</script>
{{-- <script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            pagingType: 'first_last_numbers',
        });
    });
    $(document).ready(function() {
        $('#dataTable2').DataTable({
            pagingType: 'first_last_numbers',
        });
    });
</script> --}}
@endpush
