@extends('frontend.master')
@section('title')
    {{ Auth::user()->name }}
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<link rel="stylesheet" href="{{ asset('ijaboCropTool/ijaboCropTool.min.css') }}">
<style>
    .loader {
        display: none;
        position: fixed;
        z-index: 999;
        height: 2em;
        width: 2em;
        overflow: show;
        margin: auto;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
    }

    .loader:before {
        content: '';
        display: block;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.3);
    }

    .loader:after {
        content: '';
        display: block;
        position: absolute;
        top: 50%;
        left: 50%;
        width: 1em;
        height: 1em;
        margin-top: -0.5em;
        margin-left: -0.5em;
        border-radius: 50%;
        border: 0.2em solid transparent;
        border-top-color: #3498db;
        animation: spinner 0.6s linear infinite;
    }

    @keyframes spinner {
        to { transform: rotate(360deg); }
    }
    .profile_setting a {
        background-color: transparent !important;
    }
    .profile_setting .active {
        background-color: #2490EB !important;
    }
    .profile_setting .active:hover {
        color: #fff !important;
    }
    .custom-control-input:checked ~ .custom-control-label::before {
            background-color: #007bff;
            border-color: #007bff;
        }

        .custom-control-label::before {
            border: 1px solid #007bff;
        }

        .custom-control-input:checked ~ .custom-control-label::after {
            background-color: #fff;
        }

        .custom-control-label::before,
        .custom-control-input:checked ~ .custom-control-label::after {
            width: 1.5rem;
            height: 1.5rem;
        }

        .custom-control-input:checked ~ .custom-control-label::after {
            width: 0.75rem;
            height: 0.75rem;
        }

        .custom-control-label::before,
        .custom-control-input:checked ~ .custom-control-label::after {
            border-radius: 0;
        }
</style>
@endpush
@section('content')
    <!-- Content Wrapper Start -->
    <div class="content-wrapper">

        <!-- Breadcrumb Start -->
        <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($banner->image)}});">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>User Information</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{route('front.page')}}">Home </a></li>
                        <li>User Information</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Loader Element -->
        <div class="loader"></div>

        <!-- Customer Dashboard Start -->
        <div class="container py-5">
            <div class="book-appointment-form">
                <div class="row">
                    <div class="col-12">
                        <div class="d-none d-lg-block">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h2 class="font-weight-bold py-3 mb-4">Account settings</h2>
                                </div>
                                <div>
                                    <h4 class="text_custom">Welcome Back, {{ Auth::user()->name }}!</h4>
                                    <h6>Department: {{ Auth::user()->companyDepartment->company_department_name }}</h6>
                                </div>
                            </div>
                        </div>
                        <div class="d-lg-none">
                            <h4 class="font-weight-bold">Account settings</h4>
                            <div>
                                <h4 class="text_custom">Welcome Back, {{ Auth::user()->name }}!</h4>
                                <h6>Department: {{ Auth::user()->companyDepartment->company_department_name }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 pt-0">
                        <div class="list-group profile_setting">
                            <a class="list-group-item active py-3" data-toggle="list"
                                href="#account-general">General</a>
                            <a class="list-group-item py-3" data-toggle="list"
                                href="#account-info">Personal Information</a>
                            @if ($profile)
                            <a class="list-group-item py-3" data-toggle="list"
                            href="#account-profile">Profile</a>
                            @endif
                            <a class="list-group-item py-3" data-toggle="list"
                                href="#career-info">Update Your CV <span class="text-danger">*</span></a>
                            <a class="list-group-item py-3" data-toggle="list"
                                href="#account-change-password">Change password</a>
                            <a class="list-group-item py-3" href="{{ route('job.history') }}">Your Job History</a>
                            @if ($career)
                                <a class="list-group-item py-3" href="{{ route('view.resume', ['user_id' => $career->user_id??null]) }}">View CV</a>
                            @endif
                            <a href="" class="list-group-item py-3" onclick="event.preventDefault(); document.getElementById('logoutForm').submit()"> Logout</a>
                            <form action="{{route('logout')}}" id="logoutForm" method="POST">
                                @csrf
                            </form>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="tab-content">

                            <!-- General Setting Start -->
                            <div class="tab-pane fade active show" id="account-general">
                                <div class="card-body media align-items-center">
                                    <h4>General Setting</h4>
                                    @if ($profile)
                                        @if ($profileImage && $profileImage->profile_image)
                                            <img src="{{ asset($profileImage->profile_image) }}" class="profile_image" alt="Profile Image" style="width: 200px; height: 200px; border: 5px solid #2490EB; border-radius: 50%;">
                                        @endif
                                    @else
                                    <img src="{{ asset('profile/default_profile.png') }}" class="profile_image" style="width: 200px; height: 200px; border-radius: 50%;" alt="Default Profile Image">
                                    @endif

                                    <form action="{{ route('customer.update') }}" method="POST" enctype="multipart/form-data" class="mt-4">
                                        @csrf
                                        <input type="hidden" name="id" value="{{$user->id}}">
                                        <div class="form-group mb-3">
                                            <label for="" class="form-label">Username</label>
                                            <input type="text" name="name" class="form-control rounded-0" value="{{$user->name}}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="" class="form-label">Email</label>
                                            <input type="email" name="email" class="form-control rounded-0" value="{{$user->email}}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- Profile Setting Start -->
                            @if($profile)
                            <div class="tab-pane fade" id="account-profile">
                                <div class="card-body media align-items-center">
                                    <h4>Profile Setting</h4>
                                    @if ($profileImage && $profileImage->profile_image)
                                        <img src="{{ asset($profileImage->profile_image) }}" class="profile_image" alt="Profile Image" style="width: 200px; height: 200px; border: 5px solid #2490EB;  border-radius: 50%;">
                                    @else
                                    <img src="{{ asset('profile/default_profile.png') }}" class="profile_image" style="width: 200px; height: 200px; border-radius: 50%;">
                                    @endif
                                    <div class="form-group mt-4">
                                        <label for="">Change Picture</label>
                                        <input type="file" name="profile_image" class="form-control rounded-0" id="profile_image">
                                    </div>
                                </div>
                            </div>
                            @endif
                            <!-- Password Setting Start -->
                            <div class="tab-pane fade" id="account-change-password">
                                <div class="card-body pb-2">
                                    <h4>Password Setting</h4>
                                    <form action="{{ route('mypostupdate.password') }}" method="POST">
                                        @csrf
                                        <div class="form-group mb-3">
                                            <label for="old_password" class="form-label">Current password</label>
                                            <input type="password" name="old_password" class="form-control rounded-0 @error('old_password')
                                            is-invalid
                                            @enderror">
                                            @error('old_password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="password" class="form-label">New password</label>
                                            <input type="password" name="password" class="form-control rounded-0 @error('password')
                                            is-invalid
                                            @enderror">
                                            @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="password_confirmation" class="form-label">Repeat new password</label>
                                            <input type="password" name="password_confirmation" class="form-control rounded-0">
                                        </div>
                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- Personal Information Setting Start -->
                            <div class="tab-pane fade" id="account-info">
                                <div class="card-body pb-2">
                                    <h4>Personal Information Setting</h4>
                                    <form action="{{ route('customer.info.store') }}" method="POST">
                                        @csrf
                                        <div class="form-group mb-3">
                                            <label for="nid_num" class="form-label">Nid Number</label>
                                            <input type="number" name="nid_num" class="form-control rounded-0" value="{{ $profile->nid_num??null }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="contact_number" class="form-label">Contact Number</label>
                                            <input type="tel" name="contact_number" class="form-control rounded-0 @error('contact_number')
                                            is-invalid
                                            @enderror" value="{{ $profile->contact_number??null }}">
                                            @error('contact_number')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="address" class="form-label">Address</label>
                                            <textarea class="form-control rounded-0 @error('address')
                                            is-invalid
                                            @enderror" name="address" col="10" rows="5">{{ $profile->address??null }}</textarea>
                                            @error('address')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="blood_group" class="form-label">Blood Group</label>
                                            <input type="text" name="blood_group" class="form-control rounded-0" value="{{ $profile->blood_group??null }}">
                                        </div>
                                        @if ($profile)
                                        <div class="form-group mb-3">
                                            <label class="form-label">Blood Donner?(Yes/No)</label>
                                            <select class="form-control rounded-0" name="blood_donner">
                                                <option value="1" @if ($profile->blood_donner == 1) selected @endif>Yes</option>
                                                <option value="0" @if ($profile->blood_donner == 0) selected @endif>No</option>
                                            </select>
                                        </div>
                                        @else
                                        <div class="form-group mb-3">
                                            <label class="form-label">Blood Donner?(Yes/No)</label>
                                            <select class="form-control rounded-0" name="blood_donner">
                                                <option value="1">Yes</option>
                                                <option value="0">No</option>
                                            </select>
                                        </div>
                                        @endif

                                        <div class="form-group mb-3">
                                            <label for="date_of_birth" class="form-label">Date of Birth</label>
                                            <input type="date" name="date_of_birth" class="form-control rounded-0 @error('date_of_birth')
                                            is-invalid
                                            @enderror" value="{{ $profile->date_of_birth??null }}">
                                            @error('date_of_birth')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <label for="gender" class="form-label">Select Gender</label>
                                        <div class="form-group d-flex mb-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="gender" id="male" value="male"
                                                @if ($profile)
                                                {{ $profile->gender == 'male' ? 'checked' : ''}}
                                                @endif>
                                                <label class="form-check-label" for="male">
                                                  Male
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="gender" id="female" value="female"
                                                @if ($profile)
                                                {{ $profile->gender == 'female' ? 'checked' : ''}}
                                                @endif>
                                                <label class="form-check-label" for="female">
                                                  Female
                                                </label>
                                            </div>
                                        </div>
                                        <label for="marital_status" class="form-label">Marital Status</label>
                                        <div class="form-group d-flex mb-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="marital_status" id="married" value="married"
                                                @if ($profile)
                                                {{ $profile->marital_status == 'married' ? 'checked' : ''}}
                                                @endif>
                                                <label class="form-check-label" for="married">
                                                    Married
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="marital_status" id="unmarried" value="unmarried"
                                                @if ($profile)
                                                {{ $profile->marital_status == 'unmarried' ? 'checked' : ''}}
                                                @endif>
                                                <label class="form-check-label" for="unmarried">
                                                    Unmarried
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="facebook" class="form-label">Facebook (url)</label>
                                            <input type="text" name="facebook" class="form-control rounded-0" value="{{ $profile->facebook??null }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="twitter" class="form-label">Twitter (url)</label>
                                            <input type="text" name="twitter" class="form-control rounded-0" value="{{ $profile->twitter??null }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="linkedIn" class="form-label">LinkedIn (url)</label>
                                            <input type="text" name="linkedIn" class="form-control rounded-0" value="{{ $profile->linkedIn??null }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="instagram" class="form-label">Instagram (url)</label>
                                            <input type="text" name="instagram" class="form-control rounded-0" value="{{ $profile->linkedIn??null }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- Update Your CV Start -->
                            <div class="tab-pane fade" id="career-info">
                                <div class="card-body pb-2">
                                    @if ($profile && $profileImage)
                                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                                            <strong>Congratulation! !! Now you can update your CV</strong>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    @else
                                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                            <strong>Before update your CV, You must update your personal information and profile very carefully.</strong>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    @endif
                                    @if($profile && $profileImage)
                                    <form action="{{ isset($career) ? route('career.storeOrUpdate', ['id' => $career->id]) : route('career.storeOrUpdate') }}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        @if (isset($career))
                                            @method('PUT')
                                        @endif
                                        <div class="form-group mb-3">
                                            <label for="designation" class="form-label">Designation <span class="text-danger">*</span></label>
                                            <input type="text" name="designation" class="form-control rounded-0 @error('designation')
                                            is-invalid
                                            @enderror" @if ($career)
                                                value="{{ $career->designation??null }}"
                                                @else
                                                value="{{ old('designation') }}"
                                            @endif>
                                            @error('designation')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="university" class="form-label">University <span class="text-danger">*</span></label>
                                            <input type="text" name="university" class="form-control rounded-0 @error('university')
                                            is-invalid
                                            @enderror" @if ($career)
                                            value="{{ $career->university??null }}"
                                            @else
                                            value="{{ old('university') }}"
                                            @endif>
                                            @error('university')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="company_name" class="form-label">Company Name (Recent) <span class="text-danger">*</span></label>
                                            <input type="text" name="company_name" class="form-control rounded-0 @error('company_name')
                                            is-invalid
                                            @enderror" @if ($career)
                                            value="{{ $career->company_name??null }}"
                                            @else
                                            value="{{ old('company_name') }}"
                                            @endif>>
                                            @error('company_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="career_summery" class="form-label">Career Summery <span class="text-danger">*</span></label>
                                            <textarea id="career" class="form-control rounded-0 @error('career_summery')
                                            is-invalid
                                            @enderror" name="career_summery" col="10" rows="5">@if ($career)
                                            {!! $career->career_summery??null !!}
                                            @else
                                            {!! old('career_summery') !!}
                                            @endif</textarea>
                                            @error('career_summery')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="skills" class="form-label">Skills <span class="text-danger">*</span></label>
                                            <textarea id="skill" class="form-control rounded-0 @error('skills')
                                            is-invalid
                                            @enderror" name="skills" col="10" rows="5">
                                            @if ($career)
                                            {!! $career->skills??null !!}
                                            @else
                                            {!! old('skills') !!}
                                            @endif
                                            </textarea>
                                            @error('skills')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="experience" class="form-label">Job Experience <span class="text-danger">*</span></label>
                                            <textarea id="experience" class="form-control rounded-0 @error('experience')
                                            is-invalid
                                            @enderror" name="experience" col="10" rows="5">
                                            @if ($career)
                                            {!! $career->experience??null !!}
                                            @else
                                            {!! old('experience') !!}
                                            @endif
                                            </textarea>
                                            @error('experience')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="education" class="form-label">Education <span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 @error('education')
                                            is-invalid
                                            @enderror" id="education" name="education" col="10" rows="5">
                                            @if ($career)
                                            {!! $career->education??null !!}
                                            @else
                                            {!! old('education') !!}
                                            @endif
                                            </textarea>
                                            @error('education')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="extra_cariculam" class="form-label">Extra Curriculum <span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 @error('extra_cariculam')
                                            is-invalid
                                            @enderror" id="extra_cariculam" name="extra_cariculam" col="10" rows="5">
                                            @if ($career)
                                            {!! $career->extra_cariculam??null !!}
                                            @else
                                            {!! old('extra_cariculam') !!}
                                            @endif
                                            </textarea>
                                            @error('extra_cariculam')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="language" class="form-label">Language <span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 @error('language')
                                            is-invalid
                                            @enderror" id="language" name="language" col="10" rows="5">
                                            @if ($career)
                                            {!! $career->language??null !!}
                                            @else
                                            {!! old('language') !!}
                                            @endif
                                            </textarea>
                                            @error('language')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="professional_training" class="form-label">Professional Training <span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 @error('professional_training')
                                            is-invalid
                                            @enderror" id="professional_training" name="professional_training" col="10" rows="5">
                                            @if ($career)
                                            {!! $career->professional_training??null !!}
                                            @else
                                            {!! old('professional_training') !!}
                                            @endif
                                            </textarea>
                                            @error('professional_training')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="reference" class="form-label">Reference(name, company, position, number, email)<span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 @error('reference')
                                            is-invalid
                                            @enderror" id="reference" name="reference" col="10" rows="5">
                                            @if ($career)
                                            {!! $career->reference??null !!}
                                            @else
                                            {!! old('reference') !!}
                                            @endif
                                            </textarea>
                                            @error('reference')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="declaration" class="form-label">Declaration<span class="text-danger">*</span></label>
                                            <textarea class="form-control rounded-0 @error('declaration')
                                            is-invalid
                                            @enderror" id="declaration" name="declaration" col="10" rows="5">
                                            @if ($career)
                                            {!! $career->declaration??null !!}
                                            @else
                                            {!! old('declaration') !!}
                                            @endif
                                            </textarea>
                                            @error('declaration')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="office_idcard" class="form-label mb-2">Office ID Card(Picture of frontside) <span class="text-danger">*</span></label>
                                            <input type="file" class="form-control @error('office_idcard')
                                            is-invalid
                                            @enderror" rows="5" name="office_idcard" id="office_idcard">
                                            @error('office_idcard')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                            <div>
                                                <img src="{{ asset('idcard') }}/{{ $career->office_idcard??null }}" class="img-fluid w-25" alt="" >
                                            </div>
                                        </div>

                                        <div class="form-group mb-3">
                                            <button type="submit" class="btn style1 rounded-0">Save Change</button>
                                        </div>
                                    </form>
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Customer Dashboard End -->

    </div>
    <!-- Content wrapper end -->
@endsection

@push('frontend_script')
<!-- jQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/35.1.0/classic/ckeditor.js"></script>
<script src="{{ asset('ijaboCropTool/ijaboCropTool.min.js') }}"></script>
<!-- Cropper.js JS -->
<script>
    @if(Session::has('message'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("{{ session('message') }}");
    @endif

    @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("{{ session('error') }}");
    @endif

    @if(Session::has('info'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("{{ session('info') }}");
    @endif

    @if(Session::has('warning'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("{{ session('warning') }}");
    @endif
</script>
<script>
    ClassicEditor
    .create( document.querySelector( '#skill' ) )
    .catch( error => {
        console.error( error );
    } );

    ClassicEditor
    .create( document.querySelector( '#experience' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#career' ) )
    .catch( error => {
        console.error( error );
    } );

    ClassicEditor
    .create( document.querySelector( '#education' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#extra_cariculam' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#language' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#professional_training' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#reference' ) )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
    .create( document.querySelector( '#declaration' ) )
    .catch( error => {
        console.error( error );
    } );
</script>
{{-- <script>
    $(document).ready(function() {
        $('#profile_image').ijaboCropTool({
            preview : '.profile_image',
            processUrl: '{{ route("image.crop") }}',
            withCSRF: ['_token', '{{ csrf_token() }}'],
            buttonsText:['CROP & SAVE','QUIT NOW'],
            buttonsColor:['#30bf7d','#ee5155', -15],
            onSuccess: function(message, element, status) {
                toastr.success('Image updated successfully!');
            },
            onError: function(message, element, status) {
                toastr.error('Failed to update image. Please try again.');
            }
        });
        $('#profile_image').on('change', function(){
            $('.loader').show();
        });
    });
</script> --}}
<script>
    $(document).ready(function() {
        $('#profile_image').ijaboCropTool({
            preview: '.profile_image',
            processUrl: '{{ route("image.crop") }}',
            withCSRF: ['_token', '{{ csrf_token() }}'],
            buttonsText: ['CROP & SAVE', 'QUIT NOW'],
            buttonsColor: ['#30bf7d', '#ee5155', -15],
            onSuccess: function(message, element, status) {
                $('.loader').hide();
                toastr.success('Image updated successfully!');
            },
            onError: function(message, element, status) {
                $('.loader').hide();
                toastr.error('Failed to update image. Please try again.');
            },
            onBefore: function() {
                $('.loader').show();
            },
        });

        // Show the loader when the CROP & SAVE button is clicked
        $(document).on('click', '.ijaboCropTool_btn.c_save', function() {
            $('.loader').show();
        });
    });
</script>
@endpush
