@extends('frontend.master')
@section('title')
    Mission & Vission
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@section('content')

<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($about->banner_image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Mission & Vission</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home</a></li>
                    <li>Mission & Vission</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- About Section Start -->
    <section class="about-wrap style1">
        <div class="container">
            <div class="row gx-5 align-items-center" style="padding: 100px 0;">
                <div class="col-lg-6">
                    <div class="">
                        <h4>{{ $about->mission_title??null }}</h4>
                        <p>{!! $about->mission_details??null !!}</p>
                        <h4>{{ $about->vision_title??null }}</h4>
                        <p>{!! $about->vision_details??null !!}</p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="">
                        <img src="{{ asset($about->mv_photo??null) }}" class="img-fluid w-100">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- About Section End -->

    <!-- Member Procedure Section Start -->
    {{-- <section class="about-wrap style1" style="padding: 100px 0;">
        <div class="container">
            <div class="row gx-5 align-items-center">
                <div class="col-lg-6">
                    <div class="">
                        <h2>{{ $memberprocedure->banner_title??null }}</h2>
                        <p>{!! $memberprocedure->banner_description??null !!}</p>
                        <a href="{{ route('memberprocedure.details') }}" class="btn style1 rounded-0">Learn More</a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="">
                        <img src="{{ asset($memberprocedure->banner_image??null) }}" class="img-fluid">
                    </div>
                </div>
            </div>
        </div>
    </section> --}}
    <!-- Member Procedure Section End -->
</div>
<!-- Content wrapper end -->
@endsection
