@extends('frontend.master')
@section('title')
    About
@endsection
@push('favicon')
    @php
        $logo = \App\Models\Logo::latest()->first();
    @endphp
    <link rel="icon" type="image/png" href="{{ $logo ? asset($logo->logo_image) : asset('default-favicon.png') }}">
@endpush
@section('content')

<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
    <div class="breadcrumb-wrap bg-f" style="background-image: url({{asset($about->banner_image??null)}});">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>{{ $about->title??null }}</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('front.page')}}">Home</a></li>
                    <li>{{ $about->title??null }}</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- About Section Start -->
    <section class="about-wrap style1 ptb-100">
        <div class="container">
            <div class="row gx-5 align-items-center">
                <div class="col-lg-6">
                    <div class="">
                        <h4>{{ $about->title??null }}</h4>
                        <p>{!! $about->description??null !!}</p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="">
                        <img src="{{ asset('about_photo') }}/{{ $about->about_photo }}" class="img-fluid">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- About Section End -->

    <!-- Events Section Start -->
<div class="rs-gallery pt-100 pb-100 md-pt-70 md-pb-70">
    <div class="container">

        <div class="row margin-0">
            <div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2 col-md-10 offset-md-1" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                <div class="section-title style1 text-center mb-40">
                    <h2>Photo Gallery</h2>
                </div>
            </div>
            <div id="carouselExample" class="carousel slide">
                <div class="carousel-inner">
                    @foreach($galleriess as $key => $gallery)
                        <div class="carousel-item {{$key == 0?'active':''}}">
                            <img src="{{asset($gallery->image)}}" class="d-block w-100" alt="...">
                        </div>
                    @endforeach
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExample" data-bs-slide="prev">
                  <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                  <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselExample" data-bs-slide="next">
                  <span class="carousel-control-next-icon" aria-hidden="true"></span>
                  <span class="visually-hidden">Next</span>
                </button>
              </div>

                {{-- <div class="col-lg-4 mb-0 padding-0 col-md-6 mt-4">
                    <div class="gallery-img">
                        <a class="image-popup" href="{{asset($gallery->image)}}"><img src="{{asset($gallery->image)}}" alt=""></a>
                    </div>
                </div> --}}

        </div>
    </div>
</div>
<!-- Events Section End -->

<!-- Service Section Start -->
<section class="service-wrap ptb-100">
    <div class="container">
        <div class="row ">
            <div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2 col-md-10 offset-md-1" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                <div class="section-title style1 text-center mb-40">
                    <h2>Video Gallery</h2>
                </div>
            </div>
            @foreach($galleries as $gallery)
                <div class="col-lg-6 col-12">
                    <div>{!! $gallery->video_link !!}</div>
                </div>
            @endforeach

        </div>
    </div>
</section>

<!-- Service Section End -->
</div>
<!-- Content wrapper end -->
@endsection
