@extends('frontend.master')
@section('title')
    Login
@endsection
@push('favicon')
    @php $logo = \App\Models\Logo::latest()->first() @endphp
    <link rel="icon" type="image/png" href="{{asset($logo->logo_image)}}">
@endpush
@push('frontend_style')
<!--Toaster Popup message CSS -->
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    .password-wrapper {
        position: relative;
    }

    .toggle-password {
        position: absolute;
        top: 50%;
        right: 20px;
        transform: translateY(-50%);
        cursor: pointer;
    }

    .toggle-password i {
        color: #2490EB; /* Adjust color as needed */
    }

    .toggle-password.active i {
        color: #007bff; /* Color when active, adjust as needed */
    }

</style>
@endpush

@section('content')
<!-- Content Wrapper Start -->
<div class="content-wrapper">

    <!-- Breadcrumb Start -->
   <div class="breadcrumb-wrap">
       <div class="container">
           <div class="breadcrumb-title">
               <h2>Login</h2>
               <ul class="breadcrumb-menu list-style">
                   <li><a href="index.html">Home </a></li>
                   <li>Login</li>
               </ul>
           </div>
       </div>
   </div>
    <!-- Breadcrumb End -->

    <!-- Account Section start -->
    <section class="Login-wrap pt-100 pb-75">
        <div class="container">
            <div class="row gx-5">
                <div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2">
                    <div class="login-form-wrap">
                        <div class="login-header">
                            <h3>Login</h3>
                            @if(session('error'))
                            <p class="text-danger">{{session('error')}}</p>
                            @endif
                        </div>
                        <form class="login-form" method="POST" action="{{ route('login') }}">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <input id="email" name="email" type="email" placeholder="Username Or Email Address" required>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group password-wrapper">
                                        <input id="password" name="password" placeholder="Password" type="password" >
                                        <span class="toggle-password">
                                            <i class="fa-solid fa-eye" id="togglePassword"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                                    <div class="checkbox style3">
                                        <input type="checkbox" id="test_1">
                                        <label for="test_1">
                                            Remember Me</a>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-end mb-20">
                                    <a href="{{ route('password.request') }}" class="link style1">Forgot Password?</a>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <button class="btn style1 w-100 d-block rounded-0">
                                            SIGN IN
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                   <p class="mb-0">Don't have an Account? <a class="link style1" href="{{route('register')}}">Create One</a></p>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- Account Section end -->

</div>
<!-- Content wrapper end -->
@endsection

@push('frontend_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    @if(Session::has('message'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
    }
            toastr.success("{{ session('message') }}");
    @endif

    @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.error("{{ session('error') }}");
    @endif

    @if(Session::has('info'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.info("{{ session('info') }}");
    @endif

    @if(Session::has('warning'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    }
            toastr.warning("{{ session('warning') }}");
    @endif
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var passwordField = document.getElementById('password');
        var togglePassword = document.getElementById('togglePassword');

        togglePassword.addEventListener('click', function() {
            var type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);
            if (type === 'text') {
                togglePassword.classList.remove('fa-eye');
                togglePassword.classList.add('fa-eye-slash');
            } else {
                togglePassword.classList.remove('fa-eye-slash');
                togglePassword.classList.add('fa-eye');
            }
        });
    });
</script>
@endpush
