@extends('admin.master')
@section('title')
    Role Details
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
<div class="row">
    <div class="col-md-12">
        <div class="card p-4">
            <div class="d-flex justify-content-between align-items-center pb-3">
                <h2>Role Details</h2>
                <a href="{{ route('role.index') }}" class="btn btn-info"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>

            </div>
            <div class="widget-content widget-content-area br-8">
                <table class="table table-striped table-bordered table-hover">
                    <tbody>
                        <tr>
                            <th>Role Name</th>
                            <td>{{ $role->role_name }}</td>
                        </tr>
                        <tr>
                            <th>Permissions</th>
                            <td>
                                @foreach ($role->permissions->chunk(7) as $key => $chunks)
                                <div class="row">
                                    <div class="col">
                                        @foreach ($chunks as $permission)
                                            <span class="badge bg-info">{{ $permission->permission_slug }}</span>
                                        @endforeach
                                    </div>
                                </div>
                                @endforeach
                            </td>
                        </tr>
                        <tr>
                            <th>Note</th>
                            <td><span class="badge bg-success">{{ $role->role_note }}</span></td>
                        </tr>
                        <tr>
                            <th>Can we able to delete this Role?</th>
                            <td>
                                @if ($role->is_deletable == 1)
                                    <span class="badge bg-success">Yes</span>
                                @else
                                    <span class="badge bg-danger">No</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Created Date</th>
                            <td>{{ $role->created_at->format('d-M-Y') }}</td>
                        </tr>
                        <tr>
                            <th>Last Updated</th>
                            <td>{{ $role->updated_at->format('d-M-Y') }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@endsection

@push('admin_script')
@include('admin.common.script')
@endpush
