@extends('admin.master')
@section('title')
    CV Bank list
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between">
                    <h3>CV Bank Information</h3>
                </div>
            </div>
            <div class="card-body">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                    <tr>
                        <th>List</th>
                        <th>Last Updated</th>
                        <th>Profile</th>
                        <th>Name</th>
                        <th>Designation</th>
                        <th>University</th>
                        <th>Experience</th>
                        <th>Product Category</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach ($applies as $key => $apply)
                    @if ($apply->user->role_id == 4 && $apply->user->is_merchandiser == 1)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td>{{ $apply->updated_at->format('d-M-Y') }}</td>
                        <td>
                            @if ($apply->user->profile->profileImage??null)
                            <div class="avatar-container">
                                <img alt="avatar"
                                    src="{{ asset($apply->user->profile->profileImage->profile_image??null) }}"
                                    class="rounded-circle" style="width:30px; height: 30px">
                            </div>
                            @else
                            <div class="avatar-container">
                                <img alt="avatar" src="{{ asset('profile/default_profile.png') }}"
                                class="rounded-circle" style="width:30px; height: 30px">
                            </div>
                            @endif
                        </td>
                        <td>{{ $apply->user->name }}</td>
                        <td>{{ $apply->user->career->designation }}</td>
                        <td>{{ $apply->user->career->university }}</td>
                        <td>{{ $apply->user->career->experience }}</td>
                        <td>{{ $apply->jobCircular->productType->product_name }}</td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div>
                                    <a href=""
                                        class="action-btn bs-tooltip me-2" data-toggle="tooltip"
                                        data-placement="top" title="" data-bs-original-title="View">
                                        <i class="fa-solid fa-eye text-success"></i>
                                    </a>
                                </div>
                                <div>
                                    <a href="{{ route('resume.edit', $apply->id) }}"
                                        class="action-btn bs-tooltip me-1" data-toggle="tooltip"
                                        data-placement="top" title="" data-bs-original-title="Edit">
                                        <i class="fa-regular fa-pen-to-square text-info"></i>
                                    </a>
                                </div>
                                <div>
                                    <form action="{{ route('resume.destroy', $apply->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                            class="action-btn bs-tooltip btn_custom show_confirm"
                                            data-toggle="tooltip" data-placement="top" title=""
                                            data-bs-original-title="Delete"><i
                                                class="fa-solid fa-trash-can text-warning"></i></button>
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
@endsection

@push('admin_script')

@include('admin.common.script')
@endpush
