@extends('admin.master')
@section('title')
    Recruiter
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush

@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">

                @if(session('message'))
                    <div class="alert alert-success" role="alert">
                        {{session('message')}}
                    </div>
                @endif
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('store.recruiter') }}" enctype="multipart/form-data" method="POST">
                        @csrf

                        <h3>Recruiter Information</h3>
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" name="title" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea  id="tinymce" class="editor form-control" col="10" row="3" name="description"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Banner Image</label>
                            <input type="file" name="banner_image" class="form-control">

                        </div>
                        <div class="form-group">
                            <label>Recruiter Image</label>
                            <input type="file" name="recruiter_photo" class="form-control">

                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                    <tr>
                        <th>Last Updated</th>
                        <th>Banner Image</th>
                        <th>Recruiter Photo</th>
                        <th>Title</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach ($recruiters as $key => $recruiter)
                        <tr>
                            <td>{{ $recruiter->updated_at->format('d-M-Y') }}</td>
                            <td><img src="{{ asset($recruiter->banner_image) }}" style="height: 100px"></td>
                            <td><img src="{{ asset($recruiter->recruiter_photo) }}" style="height: 100px"></td>
                            <td>{{ $recruiter->title ?? null }}</td>
                            <td>
                                <div>
                                    <a href="{{ route('edit.recruiter',['id'=>$recruiter->id]) }}"
                                        class="text-info" data-toggle="tooltip"
                                        data-placement="top" data-bs-original-title="Edit"><i class="fa-solid fa-pen-to-square fa-fw"></i>
                                    </a>
                                </div>

                            </td>
                        </tr>
                    @endforeach

                    </tbody>

                </table>
            </div>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.1.1/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
@endsection

@push('admin_script')
@include('admin.common.script')
@endpush
