@extends('admin.master')
@section('title')
    Recruiter Edit
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush

@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Recruiter Update</h3>
                        <a href="{{ route('list.recruiter') }}" class="btn btn-info"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('update.recruiter') }}" enctype="multipart/form-data" method="POST">
                        @csrf
                        <input type="hidden" value="{{$recruiter->id}}" name="id">
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" name="title" class="form-control" value="{{ $recruiter->title }}">
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea  id="tinymce" class="editor form-control" col="10" row="3" name="description">{!! $recruiter->description !!}</textarea>
                        </div>
                        <div class="form-group">
                            <label>Banner Image</label>
                            <input type="file" name="banner_image" class="form-control">
                        </div>
                        <img src="{{asset($recruiter->banner_image)}}" class="mb-2" height="100" width="100" alt="">
                        <div class="form-group">
                            <label>Recruiter Image</label>
                            <input type="file" name="recruiter_photo" class="form-control">
                        </div>
                        <img src="{{asset($recruiter->recruiter_photo)}}" class="mb-3" height="100" width="100" alt="">
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('admin_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.1.1/tinymce.min.js" referrerpolicy="origin"></script>
<script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
</script>
@include('admin.common.script')
@endpush
