@extends('admin.master')
@section('title')
    Recruiter list
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between">
                    <h3>Recruiter Information</h3>
                    <a href="{{ route('recruiters.trash') }}" class="btn btn-warning"><i class="fa-solid fa-trash-can-arrow-up fa-fw"></i> View Trash</a>
                </div>
            </div>
            <div class="card-body">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Company Logo</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Designation</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>

                        @forelse ($recruiters as $recruiter)
                        <tr>
                            <td>
                                <strong>{{ $recruiters->firstItem() + $loop->index }}</strong>
                            </td>
                            <td>
                                <img alt="logo"
                                    src="{{ asset($recruiter->company_logo??null) }}"
                                    class="rounded-circle" style="width:30px; height: 30px">
                            </td>
                            <td>{{ $recruiter->name??null }}</td>
                            <td>{{ $recruiter->email??null }}</td>
                            <td>{{ $recruiter->designation??null }}</td>
                            <td>{{ $recruiter->phone??null }}</td>
                            <td>
                                @if ($recruiter->is_recruiter == 1)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-warning">Inactive</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <div class="action-btns d-flex align-items-center">
                                    <div>
                                        <a href=""
                                            class="text-success me-2" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="View">
                                            <i class="fa-solid fa-eye"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <a href="{{ route('recruiters.edit', $recruiter->id) }}"
                                            class="text-info" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Edit"><i class="fa-solid fa-pen-to-square fa-fw"></i>
                                        </a>
                                    </div>

                                    <div>
                                        <form action="{{ route('recruiters.destroy', $recruiter->id) }}"
                                            method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-warning btn_custom show_confirm" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Delete">
                                                <i class="fa-solid fa-trash-can fa-fw"></i>
                                            </button>
                                        </form>
                                    </div>


                                </div>
                            </td>
                        </tr>
                        @empty
                        @endforelse

                    </tbody>

                </table>
            </div>
        </div>
    </div>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
@endsection

@push('admin_script')

@include('admin.common.script')
@endpush
