@extends('admin.master')
@section('title')
    Recruiter Edit
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Recruiter Edit</h3>
                        <a href="{{ route('recruiters.index') }}" class="btn btn-info"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('recruiters.update', $recruiter->id) }}" method="POST">
                        @csrf
                        @method('PUT')


                        <div class="form-group mb-3">
                            <label>Active/Deactive</label>
                            <select class="form-control" name="is_recruiter">
                                <option value="1" @if ($recruiter->is_recruiter == 1) selected @endif>Active</option>
                                <option value="0" @if ($recruiter->is_recruiter == 0) selected @endif>Deactive</option>
                            </select>
                        </div>
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" name="is_approved" type="checkbox" role="switch" id="activeStatus" @if ($recruiter->is_approved == 1)
                            checked
                        @endif>
                            <label class="form-check-label" for="activeStatus">Approved/Not</label>
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('admin_script')

@include('admin.common.script')
@endpush
