@extends('admin.master')
@section('title')
    Notices
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush

@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('notices.update', $notice->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="form-group mb-3">
                            <label for="title" class="form-label">Title</label>
                            <input type="text" class="form-control" rows="5" name="title" value="{{ $notice->title }}">
                        </div>
                        <div class="form-group mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea id="tinymce" class="editor form-control" cols="10" rows="3" name="description">{{ $notice->description }}</textarea>
                        </div>
                        <div class="form-group mb-3">
                            <label for="poster" class="form-label">Thumbnail</label>
                            <input type="file" name="poster" class="form-control">
                        </div>
                        <div class="mb-3">
                            <img src="{{ asset('notice') }}/{{ $notice->poster }}" style="height: 100px">
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('admin_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.1.1/tinymce.min.js" referrerpolicy="origin"></script>
<script type="text/javascript">
    tinymce.init({
        selector: 'textarea#default'
    });
</script>
@include('admin.common.script')
@endpush
