@extends('admin.master')
@section('title')
    Assign Member Role
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Assign Member Role to Merchandiser</h3>
                    </div>
                </div>
                <div class="card-body">
                    {{-- <form class="form-horizontal" action="{{ route('merchandiser.store') }}" method="POST">
                        @csrf
                        <div class="form-group mb-3">
                            <label for="user_id" class="form-label mb-2">Select Merchandiser</label>
                            <select id="defaultSelect" name="user_id"
                                class="form-select
                            @error('user_id')
                                is-invalid
                            @enderror">
                                <option selected>Choose a Merchandiser</option>
                                @forelse ($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @empty
                                @endforelse
                            </select>
                            @error('user_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group mb-3">
                            <label for="member_role_id" class="form-label mb-2">Select Member Role</label>
                            <select id="defaultSelect" name="member_role_id"
                                class="form-select
                            @error('member_role_id')
                                is-invalid
                            @enderror">
                                <option selected>Choose a Member Role</option>
                                @forelse ($member_roles as $member_role)
                                    <option value="{{ $member_role->id }}">{{ $member_role->member_role_name }}</option>
                                @empty
                                @endforelse
                            </select>
                            @error('member_role_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                    </form> --}}
                </div>
            </div>
        </div>
    </div>


    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Last Updated</th>
                            <th>Profile</th>
                            <th>Merchandiser Name</th>
                            <th>Merchandiser Role</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($users as $user)
                        <tr>
                            <td>
                                <strong>{{ $users->firstItem() + $loop->index }}</strong>
                            </td>
                            <td>{{ $user->updated_at->format('d-M-Y') }}</td>
                            <td>
                                @if ($user->profile->profileImage??null)
                                    <div class="avatar-container">
                                        <img alt="avatar"
                                            src="{{ asset($user->profile->profileImage->profile_image??null) }}"
                                            class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                @else
                                    <div class="avatar-container">
                                        <img alt="avatar" src="{{ asset('profile/default_profile.png') }}"
                                        class="rounded-circle" style="width:30px; height: 30px">
                                    </div>
                                @endif
                            </td>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->memberRole->member_role_name??null }}</td>
                            <td class="text-center">
                                <div class="action-btns d-flex align-items-center">
                                    <div>
                                        <a target="_blank" href="{{ route('merchandiser.show', $user->id) }}"
                                            class="text-info me-2" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Edit"><i class="fa-solid fa-eye text-success"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <a href="{{ route('merchandiser.edit', $user->id) }}"
                                            class="text-info" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Edit"><i class="fa-solid fa-pen-to-square fa-fw"></i>
                                        </a>
                                    </div>
                                    {{-- <div>
                                        <form action="{{ route('merchandiser.destroy', $user->id) }}"
                                            method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-warning btn_custom show_confirm" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Delete">
                                                <i class="fa-solid fa-trash-can fa-fw"></i>
                                            </button>
                                        </form>
                                    </div> --}}
                                </div>
                            </td>
                        </tr>
                        @empty
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
@endsection

@push('admin_script')
    @include('admin.common.script')
@endpush
