@extends('admin.master')
@section('title')
    Update Member Role
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Update Member Role to Merchandiser</h3>
                        <a href="{{ route('merchandiser.index') }}" class="btn btn-info"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('merchandiser.update', $user->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group mb-3">
                            <label for="member_role_id" class="form-label mb-2">Select Member Role</label>
                            <select id="defaultSelect" name="member_role_id"
                                class="form-select
                            @error('member_role_id')
                                is-invalid
                            @enderror">
                                <option selected>Choose a Member Role</option>
                                @forelse ($member_roles as $member_role)
                                    <option value="{{ $member_role->id }}" @if ($user->member_role_id == $member_role->id)
                                        selected
                                    @endif>{{ $member_role->member_role_name }}</option>
                                @empty
                                @endforelse
                            </select>
                            @error('member_role_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('admin_script')
    @include('admin.common.script')
@endpush
