@extends('admin.master')
@section('title')
    Member Role Edit
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Member Role Update</h3>
                        <a href="{{ route('member_role.index') }}" class="btn btn-info"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('member_role.update', $member_role->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label for="member_role_name" class="form-label mb-2">Module Name</label>
                            <input type="text" class="form-control @error('member_role_name')
                            is-invalid
                        @enderror" rows="5" name="member_role_name" value="{{ $member_role->member_role_name }}" id="member_role_name">
                            @error('member_role_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('admin_script')
    @include('admin.common.script')
@endpush
