@extends('admin.master')
@section('title')
    Mail list
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Mail Information</h3>
                    </div>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('mails.store') }}" method="POST">
                        @csrf
                        <div class="form-group mb-3">
                            <label for="subject" class="form-label">Subject</label>
                            <input type="text" class="form-control" rows="5" name="subject" value="{{ old('subject') }}">
                        </div>
                        <div class="form-group mb-3">
                            <label for="message" class="form-label">Message</label>
                            <textarea id="tinymce" class="editor form-control" cols="10" rows="3" name="message">{{ old('description') }}</textarea>
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Last Updated</th>
                            <th>Mail Subject</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($mails as $mail)
                            <tr>
                                <td>
                                    <strong>{{ $mails->firstItem() + $loop->index }}</strong>
                                </td>
                                <td>{{ $mail->updated_at->format('d-M-Y') }}</td>
                                <td>{{ $mail->subject }}</td>
                                <td>{!! $mail->message !!}</td>
                                @can('edit-user')
                                    <td class="text-center">
                                        <div class="action-btns d-flex">
                                            @can('edit-user')
                                            <div>
                                                <a href=""
                                                    class="action-btn bs-tooltip me-2" data-toggle="tooltip"
                                                    data-placement="top" title="" data-bs-original-title="View">
                                                    <i class="fa-solid fa-eye text-success"></i>
                                                </a>
                                            </div>
                                            @endcan
                                            @can('edit-user')
                                                <div>
                                                    <a href=""
                                                        class="action-btn bs-tooltip me-1" data-toggle="tooltip"
                                                        data-placement="top" title="" data-bs-original-title="Edit">
                                                        <i class="fa-regular fa-pen-to-square text-info"></i>
                                                    </a>
                                                </div>
                                            @endcan
                                            @can('delete-user')
                                                <div>
                                                    <form action="{{ route('mails.destroy', $mail->id) }}" method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit"
                                                            class="action-btn bs-tooltip btn_custom show_confirm"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-bs-original-title="Delete"><i
                                                                class="fa-solid fa-trash-can text-warning"></i></button>
                                                    </form>
                                                </div>
                                            @endcan
                                        </div>
                                    </td>
                                @endcan
                            </tr>
                        @empty
                        @endforelse
                    </tbody>

                </table>
            </div>
        </div>
    </div>
@endsection

@push('admin_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.1.1/tinymce.min.js" referrerpolicy="origin"></script>
<script type="text/javascript">
    tinymce.init({
        selector: 'textarea#default'
    });
</script>
@include('admin.common.script')
@endpush
