@extends('admin.master')
@section('title')
    Job Circular Trash list
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between">
                    <h3>Job Circular Trash list</h3>
                    <a href="{{ route('jobcircular.index') }}" class="btn btn-info"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>
                </div>
            </div>
            <div class="card-body">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Last Updated</th>
                        <th>Logo</th>
                        <th>Company</th>
                        <th>Department</th>
                        <th>Product Type</th>
                        <th>Job Title</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                        @forelse ($jobcirculars as $jobcircular)
                        <tr>
                            <td>
                                <strong>{{ $jobcirculars->firstItem() + $loop->index }}</strong>
                            </td>
                            <td>{{ $jobcircular->updated_at->format('d-M-Y') }}</td>
                            <td class="text-center">
                                <img src="{{ asset('jobcircular') }}/{{ $jobcircular->company_logo }}"
                                class="rounded-circle" alt="" style="width:30px; height:30px;">
                            </td>
                            <td>{{ $jobcircular->company->company_name }}</td>
                            <td>{{ $jobcircular->department->company_department_name }}</td>
                            <td>{{ $jobcircular->productType->product_name }}</td>
                            <td>{{ $jobcircular->job_title }}</td>
                            <td class="text-center">
                                <div class="action-btns d-flex align-items-center">
                                    <div>
                                        <a href="{{ route('jobcircular.restore', ['id' => $jobcircular->id]) }}"
                                            class="text-success me-2" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Restore"><i class="fa-solid fa-store"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <form action="{{ route('jobcircular.forcedelete', ['id' => $jobcircular->id]) }}"
                                            method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-danger btn_custom show_confirm" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Force Delete">
                                                <i class="fa-solid fa-radiation"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                    @endforelse

                    </tbody>

                </table>
            </div>
        </div>
    </div>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
@endsection

@push('admin_script')
    @include('admin.common.script')
@endpush
