@extends('admin.master')
@section('title')
    Job Details
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
<div class="row">
    <div class="col-md-12">
        <div class="card p-4">
            <div class="d-flex justify-content-between align-items-center pb-3">
                <h2>Job Details</h2>
                <a href="{{ route('jobcircular.create') }}" class="btn btn-info"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>

            </div>
            <div class="widget-content widget-content-area br-8">
                <table class="table table-striped table-bordered table-hover">
                    <tbody>
                        <tr><th colspan="2"><h3>{{ $rejobcircular->job_title }}</h3></th></tr>
                        <tr>
                            <th>Company Logo</th>
                            <td>
                                <img src="{{ asset('jobcircular') }}/{{ $rejobcircular->company_logo }}"
                                class="" alt="" style="width:100px; height:100px;">
                            </td>
                        </tr>
                        <tr>
                            <th>Thumbnail</th>
                            <td>
                                <img src="{{ asset('jobcircular') }}/{{ $rejobcircular->job_banner }}"
                                class="" alt="" style="width:100px; height:100px;">
                            </td>
                        </tr>
                        <tr>
                            <th>Company</th>
                            <td>{{ $rejobcircular->company->company_name }}</td>
                        </tr>
                        <tr>
                            <th>Department</th>
                            <td>{{ $rejobcircular->department->company_department_name }}</td>
                        </tr>
                        <tr>
                            <th>Product Type</th>
                            <td>{{ $rejobcircular->productType->product_name }}</td>
                        </tr>
                        <tr>
                            <th>Vacancy</th>
                            <td>{{ $rejobcircular->vacancy }}</td>
                        </tr>
                        <tr>
                            <th>Responsibilities</th>
                            <td>{!! $rejobcircular->responsibilities !!}</td>
                        </tr>
                        <tr>
                            <th>Experience</th>
                            <td>{!! $rejobcircular->experience !!}</td>
                        </tr>
                        <tr>
                            <th>Qualification</th>
                            <td>{{ $rejobcircular->qualification }}</td>
                        </tr>
                        <tr>
                            <th>Others Facilities</th>
                            <td>{{ $rejobcircular->others_facilities }}</td>
                        </tr>
                        <tr>
                            <th>Salary Range</th>
                            <td>{{ $rejobcircular->salary_range }}</td>
                        </tr>
                        <tr>
                            <th>Location</th>
                            <td>{!! $rejobcircular->location !!}</td>
                        </tr>
                        <tr>
                            <th>Dead Line</th>
                            <td>{{ $rejobcircular->deadline_till }}</td>
                        </tr>
                        <tr>
                            <th>Created Date</th>
                            <td>{{ $rejobcircular->created_at->format('d-M-Y') }}</td>
                        </tr>
                        <tr>
                            <th>Last Updated</th>
                            <td>{{ $rejobcircular->updated_at->format('d-M-Y') }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@endsection

@push('admin_script')
@include('admin.common.script')
@endpush
