@extends('admin.master')
@section('title')
    Job Circular list
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Job Circular Information</h3>
                        <a href="{{ route('jobcircular.trash') }}" class="btn btn-warning"><i class="fa-solid fa-trash-can-arrow-up fa-fw"></i> View Trash</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Last Updated</th>
                        <th>Publisher</th>
                        <th>Logo</th>
                        <th>Company</th>
                        <th>Company Type</th>
                        <th>Department</th>
                        <th>Product Type</th>
                        <th>Job Title</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                        @forelse ($rejobcirculars as $jobcircular)
                        <tr>
                            <td>
                                <strong>{{ $rejobcirculars->firstItem() + $loop->index }}</strong>
                            </td>
                            <td>{{ $jobcircular->updated_at->format('d-M-Y') }}</td>
                            <td>{{ $jobcircular->recruiter->name }}</td>
                            <td class="text-center">
                                <img src="{{ asset('jobcircular') }}/{{ $jobcircular->company_logo }}"
                                class="rounded-circle" alt="" style="width:30px; height:30px;">
                            </td>
                            <td>{{ $jobcircular->company_nam }}</td>
                            <td>{{ $jobcircular->company->company_name }}</td>
                            <td>{{ $jobcircular->department->company_department_name }}</td>
                            <td>{{ $jobcircular->productType->product_name }}</td>
                            <td>{{ $jobcircular->job_title }}</td>
                            <td class="text-center">
                                <div class="action-btns d-flex align-items-center">
                                    <div>
                                        <a href="{{ route('rejobcircular.view', ['id' => $jobcircular->id]) }}"
                                            class="text-success me-2" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="View">
                                            <i class="fa-solid fa-eye"></i>
                                        </a>
                                    </div>
                                    {{-- <div>
                                        <a href="{{ route('jobcircular.edit', $jobcircular->id) }}"
                                            class="text-info" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Edit"><i class="fa-solid fa-pen-to-square fa-fw"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <form action="{{ route('jobcircular.destroy', $jobcircular->id) }}"
                                            method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-warning btn_custom show_confirm" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Delete">
                                                <i class="fa-solid fa-trash-can fa-fw"></i>
                                            </button>
                                        </form>
                                    </div> --}}
                                </div>
                            </td>
                        </tr>
                    @empty
                    @endforelse

                    </tbody>

                </table>
            </div>
        </div>
    </div>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
@endsection

@push('admin_script')
    @include('admin.common.script')
@endpush
